/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.table.distributed.PartitionModificationCounter;
import org.apache.ignite.internal.table.distributed.TableStatsStalenessConfiguration;
import org.apache.ignite.internal.table.message.GetEstimatedSizeWithLastModifiedTsRequest;
import org.apache.ignite.internal.table.message.PartitionModificationInfoMessage;
import org.apache.ignite.internal.table.message.TableMessageGroup;
import org.apache.ignite.internal.table.message.TableMessagesFactory;
import org.jetbrains.annotations.Nullable;

public class PartitionModificationCounterFactory {
    private final Supplier<HybridTimestamp> currentTimestampSupplier;
    private final MessagingService messagingService;
    private final Map<TablePartitionId, PartitionModificationCounter> partitionsInfo = new HashMap<TablePartitionId, PartitionModificationCounter>();
    private static final TableMessagesFactory TABLE_MESSAGES_FACTORY = new TableMessagesFactory();

    public PartitionModificationCounterFactory(Supplier<HybridTimestamp> currentTimestampSupplier, MessagingService messagingService) {
        this.currentTimestampSupplier = currentTimestampSupplier;
        this.messagingService = messagingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionModificationCounter create(SizeSupplier partitionSizeSupplier, StalenessConfigurationSupplier stalenessConfigurationSupplier, int tableId, int partitionId) {
        PartitionModificationCounter info = new PartitionModificationCounter(this.currentTimestampSupplier.get(), partitionSizeSupplier, stalenessConfigurationSupplier);
        PartitionModificationCounterFactory partitionModificationCounterFactory = this;
        synchronized (partitionModificationCounterFactory) {
            this.partitionsInfo.put(new TablePartitionId(tableId, partitionId), info);
        }
        return info;
    }

    public void start() {
        this.messagingService.addMessageHandler(TableMessageGroup.class, this::handleMessage);
    }

    private void handleMessage(NetworkMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
        if (message instanceof GetEstimatedSizeWithLastModifiedTsRequest) {
            this.handleRequestCounter(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestCounter(InternalClusterNode sender) {
        ArrayList<PartitionModificationInfoMessage> modificationInfo = new ArrayList<PartitionModificationInfoMessage>();
        PartitionModificationCounterFactory partitionModificationCounterFactory = this;
        synchronized (partitionModificationCounterFactory) {
            for (Map.Entry<TablePartitionId, PartitionModificationCounter> ent : this.partitionsInfo.entrySet()) {
                PartitionModificationCounter info = ent.getValue();
                TablePartitionId tblPartId = ent.getKey();
                PartitionModificationInfoMessage infoMsg = TABLE_MESSAGES_FACTORY.partitionModificationInfoMessage().tableId(tblPartId.tableId()).partId(tblPartId.partitionId()).estimatedSize(info.estimatedSize()).lastModificationCounter(info.lastMilestoneTimestamp().longValue()).build();
                modificationInfo.add(infoMsg);
            }
        }
        this.messagingService.send(sender, (NetworkMessage)TABLE_MESSAGES_FACTORY.getEstimatedSizeWithLastModifiedTsResponse().modifications(modificationInfo).build());
    }

    @FunctionalInterface
    public static interface SizeSupplier {
        public long get();
    }

    @FunctionalInterface
    public static interface StalenessConfigurationSupplier {
        public TableStatsStalenessConfiguration get();
    }
}

