/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class TimedEntry
implements Map.Entry<Tuple, Tuple> {
    private final Map.Entry<Tuple, Tuple> entry;
    private final HybridTimestamp lastEntryUpdate;

    private TimedEntry(Map.Entry<Tuple, Tuple> entry, HybridTimestamp lastEntryUpdate) {
        this.entry = entry;
        this.lastEntryUpdate = lastEntryUpdate;
    }

    @Override
    public Tuple getKey() {
        return this.entry.getKey();
    }

    @Override
    public Tuple getValue() {
        return this.entry.getValue();
    }

    @Override
    public Tuple setValue(Tuple value) {
        return this.entry.setValue(value);
    }

    @Nullable
    public static TimedEntry of(@Nullable Map.Entry<Tuple, Tuple> entry, HybridTimestamp timestamp) {
        return entry != null ? new TimedEntry(entry, timestamp) : null;
    }

    public Map.Entry<Tuple, Tuple> entry() {
        return this.entry;
    }

    public HybridTimestamp lastEntryUpdate() {
        return this.lastEntryUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedEntry that = (TimedEntry)o;
        return Objects.equals(this.entry, that.entry) && Objects.equals(this.lastEntryUpdate, that.lastEntryUpdate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entry, this.lastEntryUpdate);
    }
}

