/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.nearcache.EmbeddedNearCacheKeyImpl;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.TupleMarshaller;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.AbstractTableView;
import org.apache.ignite.internal.table.DataStreamer;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.RecordViewInternal;
import org.apache.ignite.internal.table.TableRow;
import org.apache.ignite.internal.table.TupleMarshallerCache;
import org.apache.ignite.internal.table.TupleStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.TableRowEventType;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.TupleHelper;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheRecordRowEventSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheSchemaVersionAwareSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class RecordBinaryViewImpl
extends AbstractTableView<Tuple>
implements RecordView<Tuple>,
RecordViewInternal<Tuple>,
NearCacheEntriesProvider<Tuple, Tuple, BinaryRowEx> {
    private final TupleMarshallerCache marshallerCache;

    public RecordBinaryViewImpl(InternalTable tbl, SchemaRegistry schemaRegistry, SchemaVersions schemaVersions, IgniteSql sql, MarshallersProvider marshallers) {
        super(tbl, schemaVersions, schemaRegistry, sql, marshallers);
        this.marshallerCache = new TupleMarshallerCache(schemaRegistry);
    }

    public Tuple get(@Nullable Transaction tx, Tuple keyRec) {
        return (Tuple)ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            Row keyRow = this.marshal(keyRec, schemaVersion, true);
            return this.tbl.get((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(row -> this.wrap((BinaryRow)row, schemaVersion));
        });
    }

    public TupleMarshaller marshaller(int schemaVersion) {
        return this.marshallerCache.marshaller(this.tbl::name, schemaVersion);
    }

    public List<Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return (List)ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, (String)"keyRecs", (String)"key");
        return this.doOperation(tx, schemaVersion -> this.tbl.getAll(this.mapToBinary(keyRecs, schemaVersion, true), (InternalTransaction)tx).thenApply(binaryRows -> this.wrap((Collection<BinaryRow>)binaryRows, schemaVersion, true)));
    }

    public boolean contains(@Nullable Transaction tx, Tuple keyRec) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            Row keyRow = this.marshal(keyRec, schemaVersion, true);
            return this.tbl.get((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(Objects::nonNull);
        });
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> keysRows = this.mapToBinary(keys, schemaVersion, true);
            return this.tbl.getAll(keysRows, (InternalTransaction)tx).thenApply(rows -> {
                for (BinaryRow row : rows) {
                    if (row != null) continue;
                    return false;
                }
                return true;
            });
        });
    }

    public void upsert(@Nullable Transaction tx, Tuple rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(rec, schemaVersion, false);
            return this.tbl.upsert((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public void upsertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        return this.doOperation(tx, schemaVersion -> this.tbl.upsertAll(this.mapToBinary(recs, schemaVersion, false), (InternalTransaction)tx));
    }

    public Tuple getAndUpsert(@Nullable Transaction tx, Tuple rec) {
        return (Tuple)ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    public CompletableFuture<Tuple> getAndUpsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(rec, schemaVersion, false);
            return this.tbl.getAndUpsert((BinaryRowEx)row, (InternalTransaction)tx).thenApply(resultRow -> this.wrap((BinaryRow)resultRow, schemaVersion));
        });
    }

    public boolean insert(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.insertAsync(tx, rec));
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(rec, schemaVersion, false);
            return this.tbl.insert((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public List<Tuple> insertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        return (List)ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    public CompletableFuture<List<Tuple>> insertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        return this.doOperation(tx, schemaVersion -> this.tbl.insertAll(this.mapToBinary(recs, schemaVersion, false), (InternalTransaction)tx).thenApply(rows -> this.wrap((Collection<BinaryRow>)rows, schemaVersion, false)));
    }

    public boolean replace(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(rec, schemaVersion, false);
            return this.tbl.replace((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.doOperation(tx, schemaVersion -> {
            Row oldRow = this.marshal(oldRec, schemaVersion, false);
            Row newRow = this.marshal(newRec, schemaVersion, false);
            return this.tbl.replace((BinaryRowEx)oldRow, (BinaryRowEx)newRow, (InternalTransaction)tx);
        });
    }

    public Tuple getAndReplace(@Nullable Transaction tx, Tuple rec) {
        return (Tuple)ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(rec, schemaVersion, false);
            return this.tbl.getAndReplace((BinaryRowEx)row, (InternalTransaction)tx).thenApply(resultRow -> this.wrap((BinaryRow)resultRow, schemaVersion));
        });
    }

    public boolean delete(@Nullable Transaction tx, Tuple keyRec) {
        return (Boolean)ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            Row keyRow = this.marshal(keyRec, schemaVersion, true);
            return this.tbl.delete((BinaryRowEx)keyRow, (InternalTransaction)tx);
        });
    }

    public boolean deleteExact(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(rec, schemaVersion, false);
            return this.tbl.deleteExact((BinaryRowEx)row, (InternalTransaction)tx);
        });
    }

    public Tuple getAndDelete(@Nullable Transaction tx, Tuple keyRec) {
        return (Tuple)ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    public CompletableFuture<Tuple> getAndDeleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            Row keyRow = this.marshal(keyRec, schemaVersion, true);
            return this.tbl.getAndDelete((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(row -> this.wrap((BinaryRow)row, schemaVersion));
        });
    }

    public List<Tuple> deleteAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return (List)ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    public void deleteAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.deleteAllAsync(tx));
    }

    public CompletableFuture<List<Tuple>> deleteAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        return this.doOperation(tx, schemaVersion -> this.tbl.deleteAll(this.mapToBinary(keyRecs, schemaVersion, true), (InternalTransaction)tx).thenApply(rows -> this.wrapKeys((Collection<BinaryRow>)rows, schemaVersion)));
    }

    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name().toCanonicalForm(), new Object[0]).thenApply(r -> null);
    }

    public List<Tuple> deleteAllExact(@Nullable Transaction tx, Collection<Tuple> recs) {
        return (List)ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    public CompletableFuture<List<Tuple>> deleteAllExactAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        return this.doOperation(tx, schemaVersion -> this.tbl.deleteAllExact(this.mapToBinary(recs, schemaVersion, false), (InternalTransaction)tx).thenApply(rows -> this.wrap((Collection<BinaryRow>)rows, schemaVersion, false)));
    }

    private Row marshal(Tuple tuple, int schemaVersion, boolean keyOnly) {
        TupleMarshaller marshaller = this.marshaller(schemaVersion);
        return RecordBinaryViewImpl.marshal(tuple, marshaller, keyOnly);
    }

    private static Row marshal(Tuple tuple, TupleMarshaller marshaller, boolean keyOnly) {
        if (keyOnly) {
            return marshaller.marshalKey(tuple);
        }
        return marshaller.marshal(tuple);
    }

    @TestOnly
    @VisibleForTesting
    public CompletableFuture<BinaryRowEx> tupleToBinaryRow(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            Row row = this.marshal(rec, schemaVersion, false);
            return CompletableFuture.completedFuture(row);
        });
    }

    @TestOnly
    @VisibleForTesting
    public CompletableFuture<Tuple> binaryRowToTuple(@Nullable Transaction tx, BinaryRow row) {
        return this.doOperation(tx, schemaVersion -> CompletableFuture.completedFuture(this.wrap(row, schemaVersion)));
    }

    @Nullable
    private Tuple wrap(@Nullable BinaryRow row, int targetSchemaVersion) {
        return row == null ? null : TableRow.tuple(this.rowConverter.resolveRow(row, targetSchemaVersion));
    }

    private List<Tuple> wrap(Collection<BinaryRow> rows, int targetSchemaVersion, boolean addNull) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> wrapped = new ArrayList<Tuple>(rows.size());
        for (Row row : this.rowConverter.resolveRows(rows, targetSchemaVersion)) {
            if (row != null) {
                wrapped.add(TableRow.tuple(row));
                continue;
            }
            if (!addNull) continue;
            wrapped.add(null);
        }
        return wrapped;
    }

    private List<Tuple> wrapKeys(Collection<BinaryRow> rows, int targetSchemaVersion) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> wrapped = new ArrayList<Tuple>(rows.size());
        for (Row row : this.rowConverter.resolveKeys(rows, targetSchemaVersion)) {
            if (row == null) continue;
            wrapped.add(TableRow.tuple(row));
        }
        return wrapped;
    }

    private Collection<BinaryRowEx> mapToBinary(Collection<Tuple> rows, int schemaVersion, boolean key) {
        ArrayList<BinaryRowEx> mapped = new ArrayList<BinaryRowEx>(rows.size());
        for (Tuple row : rows) {
            mapped.add((BinaryRowEx)this.marshal(row, schemaVersion, key));
        }
        return mapped;
    }

    private Collection<BinaryRowEx> mapToBinary(Collection<Tuple> rows, int schemaVersion, @Nullable BitSet deleted) {
        ArrayList<BinaryRowEx> mapped = new ArrayList<BinaryRowEx>(rows.size());
        TupleMarshaller marshaller = this.marshaller(schemaVersion);
        for (Tuple row : rows) {
            boolean key = deleted != null && deleted.get(mapped.size());
            mapped.add((BinaryRowEx)RecordBinaryViewImpl.marshal(row, marshaller, key));
        }
        return mapped;
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Tuple>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        TupleStreamerPartitionAwarenessProvider partitioner = new TupleStreamerPartitionAwarenessProvider(this.rowConverter.registry(), this.tbl.partitions());
        StreamerBatchSender batchSender = (partitionId, rows, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.withSchemaSync(null, schemaVersion -> this.tbl.updateAll(this.mapToBinary((Collection<Tuple>)rows, schemaVersion, deleted), deleted, (int)partitionId)));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, options, batchSender, partitioner, this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, Tuple> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        TupleStreamerPartitionAwarenessProvider partitioner = new TupleStreamerPartitionAwarenessProvider(this.rowConverter.registry(), this.tbl.partitions());
        StreamerBatchSender batchSender = (partitionIndex, rows, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.tbl.partitionLocation((int)partitionIndex).thenCompose(node -> this.tbl.streamerReceiverRunner().runReceiverAsync(receiver, receiverArg, rows, (InternalClusterNode)node, receiver.units())));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options, batchSender, resultSubscriber, partitioner, this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    @Override
    public CompletableFuture<Void> updateAll(int partitionId, Collection<Tuple> rows, @Nullable BitSet deleted) {
        return this.doOperation(null, schemaVersion -> this.tbl.updateAll(this.mapToBinary(rows, schemaVersion, deleted), deleted, partitionId));
    }

    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Tuple>> subscriber, @Nullable ContinuousQueryOptions options) {
        Objects.requireNonNull(subscriber);
        this.tbl.queryContinuously(subscriber, options, (row, schema) -> this.wrap((BinaryRow)row, row.schemaVersion()));
    }

    public Class<Tuple> valueType() {
        return Tuple.class;
    }

    public CompletableFuture<NearCacheKey<Tuple, BinaryRowEx>> getNearCacheKeyAsync(Tuple key, boolean enforceKeyOnly) {
        return this.doOperation(null, schemaVersion -> {
            Row keyRow;
            SchemaDescriptor schemaDscr = this.rowConverter.registry().lastKnownSchema();
            List keyColumns = schemaDscr.keyColumns();
            if (!enforceKeyOnly) {
                Tuple keyRec;
                if (key.columnCount() == keyColumns.size()) {
                    keyRec = key;
                } else {
                    ArrayList<String> keyColumnNames = new ArrayList<String>(keyColumns.size());
                    for (Column c : keyColumns) {
                        keyColumnNames.add(c.name());
                    }
                    keyRec = TupleHelper.copyColumns((Tuple)key, keyColumnNames);
                }
                keyRow = this.marshal(keyRec, schemaVersion, true);
            } else {
                keyRow = this.marshal(key, schemaVersion, true);
            }
            return CompletableFuture.completedFuture(new EmbeddedNearCacheKeyImpl<Tuple>(key, (BinaryRowEx)keyRow));
        });
    }

    public CompletableFuture<Collection<NearCacheKey<Tuple, BinaryRowEx>>> getNearCacheKeysAsync(Iterable<? extends Tuple> keys, boolean enforceKeyOnly) {
        return this.doOperation(null, schemaVersion -> {
            ArrayList<EmbeddedNearCacheKeyImpl<Tuple>> cacheKeys = new ArrayList<EmbeddedNearCacheKeyImpl<Tuple>>();
            SchemaDescriptor schemaDscr = this.rowConverter.registry().lastKnownSchema();
            List keyColumns = schemaDscr.keyColumns();
            for (Tuple rec : keys) {
                Tuple keyRec;
                if (!enforceKeyOnly && rec.columnCount() != keyColumns.size()) {
                    ArrayList<String> keyColumnNames = new ArrayList<String>(keyColumns.size());
                    for (Column c : keyColumns) {
                        keyColumnNames.add(c.name());
                    }
                    keyRec = TupleHelper.copyColumns((Tuple)rec, keyColumnNames);
                } else {
                    keyRec = rec;
                }
                Row keyRow = this.marshal(keyRec, schemaVersion, true);
                EmbeddedNearCacheKeyImpl<Tuple> cacheKey = new EmbeddedNearCacheKeyImpl<Tuple>(rec, (BinaryRowEx)keyRow);
                cacheKeys.add(cacheKey);
            }
            return CompletableFuture.completedFuture(cacheKeys);
        });
    }

    public CompletableFuture<Pair<NearCacheKey<Tuple, BinaryRowEx>, NearCacheValue<Tuple>>> getNearCacheValueAsync(@Nullable Transaction tx, NearCacheKey<Tuple, BinaryRowEx> key) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = (BinaryRowEx)key.serializedKey();
            if (keyRow == null || schemaVersion != keyRow.schemaVersion()) {
                keyRow = this.marshal((Tuple)key.key(), schemaVersion, true);
            }
            EmbeddedNearCacheKeyImpl<Tuple> finalCacheKey = new EmbeddedNearCacheKeyImpl<Tuple>((Tuple)key.key(), keyRow);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> {
                NearCacheValue cacheVal;
                if (binaryRow == null) {
                    cacheVal = new NearCacheValue();
                } else {
                    @Nullable Tuple val = this.wrap((BinaryRow)binaryRow, schemaVersion);
                    cacheVal = new NearCacheValue((Object)val);
                }
                return new Pair((Object)finalCacheKey, (Object)cacheVal);
            });
        });
    }

    public CompletableFuture<Map<NearCacheKey<Tuple, BinaryRowEx>, NearCacheValue<Tuple>>> getNearCacheValuesAsync(@Nullable Transaction tx, Collection<NearCacheKey<Tuple, BinaryRowEx>> nearCacheKeys) {
        return this.doOperation(tx, schemaVersion -> {
            ArrayList<EmbeddedNearCacheKeyImpl<Tuple>> ncKeys = new ArrayList<EmbeddedNearCacheKeyImpl<Tuple>>(nearCacheKeys.size());
            ArrayList<BinaryRowEx> keyRows = new ArrayList<BinaryRowEx>(nearCacheKeys.size());
            for (NearCacheKey nearCacheKey : nearCacheKeys) {
                BinaryRowEx keyRow = (BinaryRowEx)nearCacheKey.serializedKey();
                if (keyRow == null || schemaVersion != keyRow.schemaVersion()) {
                    keyRow = this.marshal((Tuple)nearCacheKey.key(), schemaVersion, true);
                }
                keyRows.add(keyRow);
                ncKeys.add(new EmbeddedNearCacheKeyImpl<Tuple>((Tuple)nearCacheKey.key(), keyRow));
            }
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> {
                assert (rows.size() == keyRows.size());
                LinkedHashMap<NearCacheKey, NearCacheValue> ret = new LinkedHashMap<NearCacheKey, NearCacheValue>(rows.size());
                for (int i = 0; i < rows.size(); ++i) {
                    NearCacheValue cacheVal;
                    BinaryRow binaryRow = (BinaryRow)rows.get(i);
                    if (binaryRow == null) {
                        cacheVal = new NearCacheValue();
                    } else {
                        @Nullable Tuple val = this.wrap(binaryRow, schemaVersion);
                        cacheVal = new NearCacheValue((Object)val);
                    }
                    NearCacheKey nearCacheKey = (NearCacheKey)ncKeys.get(i);
                    ret.put(nearCacheKey, cacheVal);
                }
                return ret;
            });
        });
    }

    public void subscribeToNearCacheUpdates(Flow.Subscriber<TableRowEventBatch<Map.Entry<Tuple, Tuple>>> subscriber, int updateInterval) {
        ContinuousQueryOptions opts = ContinuousQueryOptions.builder().pollIntervalMs(updateInterval).eventTypes(new TableRowEventType[]{TableRowEventType.CREATED, TableRowEventType.UPDATED, TableRowEventType.REMOVED}).build();
        this.queryContinuously((Flow.Subscriber<TableRowEventBatch<Tuple>>)new NearCacheSchemaVersionAwareSubscriber((Flow.Subscriber)new NearCacheRecordRowEventSubscriber(subscriber), () -> this.doOperation(null, CompletableFuture::completedFuture)), opts);
    }

    public void close() throws Exception {
    }
}

