/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.jetbrains.annotations.Nullable;

public interface IndexScanCriteria {
    public static Range range(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        return new Range(lowerBound, upperBound, flags);
    }

    public static Lookup lookup(BinaryTuple key) {
        return new Lookup(key);
    }

    public static Range unbounded() {
        return Range.UNBOUNDED;
    }

    public static class Range
    implements IndexScanCriteria {
        private static final Range UNBOUNDED = new Range(null, null, 0);
        @Nullable
        private final BinaryTuplePrefix lowerBound;
        @Nullable
        private final BinaryTuplePrefix upperBound;
        private final int flags;

        private Range(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.flags = flags;
        }

        @Nullable
        public BinaryTuplePrefix lowerBound() {
            return this.lowerBound;
        }

        @Nullable
        public BinaryTuplePrefix upperBound() {
            return this.upperBound;
        }

        public int flags() {
            return this.flags;
        }
    }

    public static class Lookup
    implements IndexScanCriteria {
        private final BinaryTuple key;

        private Lookup(BinaryTuple key) {
            this.key = key;
        }

        public BinaryTuple key() {
            return this.key;
        }
    }
}

