/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.policy;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTablePolicyPredicate;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite.internal.catalog.events.CreateTablePolicyEventParameters;
import org.apache.ignite.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite.internal.catalog.events.DropTablePolicyEventParameters;
import org.apache.ignite.internal.catalog.events.ModifyTableRowLevelSecurityEventParameters;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.table.policy.AllowForAllChecker;
import org.apache.ignite.internal.table.policy.AllowForSystemUserChecker;
import org.apache.ignite.internal.table.policy.PolicyBasedChecker;
import org.apache.ignite.internal.table.policy.RlsChecker;
import org.apache.ignite.internal.table.policy.RlsCheckerChain;
import org.apache.ignite.internal.table.policy.RlsPolicy;
import org.apache.ignite.internal.table.policy.VersionResolver;
import org.apache.ignite.internal.util.LongPriorityQueue;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class RlsPolicyManager {
    private static final Predicate<String> ALL_MATCHES = role -> true;
    private static final Predicate<String> NONE_MATCHES = role -> false;
    private final ConcurrentMap<Integer, RlsCheckerChain> checkers = new ConcurrentHashMap<Integer, RlsCheckerChain>();
    private final LongPriorityQueue<DestroyTableEvent> destructionEventsQueue = new LongPriorityQueue(DestroyTableEvent::catalogVersion);
    private final EventListener<CatalogEventParameters> onRlsChanged = this::onRlsChanged;
    private final EventListener<CreateTableEventParameters> onTableCreated = this::onTableCreated;
    private final EventListener<DropTableEventParameters> onTableDropped = this::onTableDropped;
    private final EventListener<CreateTablePolicyEventParameters> onPolicyCreated = this::onTablePolicyAdded;
    private final EventListener<DropTablePolicyEventParameters> onPolicyDropped = this::onTablePolicyDropped;
    private final EventListener<ChangeLowWatermarkEventParameters> onWatermarkChanged = this::onLwmChanged;
    private final CatalogService catalogService;
    private final SchemaManager schemaManager;
    private final LowWatermark lowWatermark;
    private final Executor cleanUpExecutor;

    public RlsPolicyManager(CatalogService catalogService, SchemaManager schemaManager, LowWatermark lowWatermark, Executor cleanUpExecutor) {
        this.catalogService = catalogService;
        this.schemaManager = schemaManager;
        this.lowWatermark = lowWatermark;
        this.cleanUpExecutor = cleanUpExecutor;
    }

    public RlsChecker checkerForTable(int tableId, HybridTimestamp ts) {
        RlsChecker checker;
        RlsCheckerChain chain = (RlsCheckerChain)this.checkers.get(tableId);
        RlsChecker rlsChecker = checker = chain != null ? chain.resolve(ts.longValue()) : null;
        if (checker == null) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, IgniteStringFormatter.format((String)"Row-Level Security checker not found. Is operation drown under low watermark? [tableId={}, ts={}]", (Object[])new Object[]{tableId, ts}));
        }
        return checker;
    }

    public void start() {
        this.recoverState();
        this.catalogService.listen((Event)CatalogEvent.TABLE_CREATE, this.onTableCreated);
        this.catalogService.listen((Event)CatalogEvent.TABLE_ALTER, this.onRlsChanged);
        this.catalogService.listen((Event)CatalogEvent.TABLE_DROP, this.onTableDropped);
        this.catalogService.listen((Event)CatalogEvent.TABLE_POLICY_CREATE, this.onPolicyCreated);
        this.catalogService.listen((Event)CatalogEvent.TABLE_POLICY_DROP, this.onPolicyDropped);
        this.lowWatermark.listen((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.onWatermarkChanged);
    }

    private void recoverState() {
        int startVer = this.catalogService.earliestCatalogVersion();
        int endVer = this.catalogService.latestCatalogVersion();
        Int2ObjectOpenHashMap statesByTableId = new Int2ObjectOpenHashMap();
        for (int ver = startVer; ver <= endVer; ++ver) {
            Catalog catalog = this.catalogService.catalog(ver);
            IntOpenHashSet droppedTables = new IntOpenHashSet((IntCollection)statesByTableId.keySet());
            for (CatalogTableDescriptor table : catalog.tables()) {
                class TableState {
                    private boolean previousSecurityEnabled;
                    private IntSet policiesSet;

                    private TableState(boolean previousSecurityEnabled, IntSet policiesSet) {
                        this.previousSecurityEnabled = previousSecurityEnabled;
                        this.policiesSet = policiesSet;
                    }
                }
                TableState tableState = (TableState)statesByTableId.get(table.id());
                IntSet currentPoliciesSet = (IntSet)catalog.policies(table.id()).stream().map(CatalogObjectDescriptor::id).collect(Collectors.toCollection(IntOpenHashSet::new));
                droppedTables.remove(table.id());
                if (tableState == null) {
                    tableState = new TableState(table.securityEnabled(), currentPoliciesSet);
                    statesByTableId.put(table.id(), (Object)tableState);
                } else if (table.securityEnabled() != tableState.previousSecurityEnabled) {
                    tableState.previousSecurityEnabled = table.securityEnabled();
                    tableState.policiesSet = currentPoliciesSet;
                } else {
                    if (tableState.policiesSet.equals(currentPoliciesSet)) continue;
                    tableState.policiesSet = currentPoliciesSet;
                }
                if (table.securityEnabled()) {
                    this.updatePolicies(catalog, table.id());
                    continue;
                }
                this.disableRls(catalog, table.id());
            }
            droppedTables.forEach(arg_0 -> this.lambda$recoverState$2((Int2ObjectMap)statesByTableId, catalog, arg_0));
        }
    }

    public void stop() {
        this.catalogService.removeListener((Event)CatalogEvent.TABLE_CREATE, this.onTableCreated);
        this.catalogService.removeListener((Event)CatalogEvent.TABLE_ALTER, this.onRlsChanged);
        this.catalogService.removeListener((Event)CatalogEvent.TABLE_DROP, this.onTableDropped);
        this.catalogService.removeListener((Event)CatalogEvent.TABLE_POLICY_CREATE, this.onPolicyCreated);
        this.catalogService.removeListener((Event)CatalogEvent.TABLE_POLICY_DROP, this.onPolicyDropped);
        this.lowWatermark.removeListener((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.onWatermarkChanged);
        this.checkers.clear();
        this.destructionEventsQueue.clear();
    }

    private CompletableFuture<Boolean> onRlsChanged(CatalogEventParameters parameters) {
        if (parameters instanceof ModifyTableRowLevelSecurityEventParameters) {
            ModifyTableRowLevelSecurityEventParameters modifyRlsParameters = (ModifyTableRowLevelSecurityEventParameters)parameters;
            Catalog catalog = this.catalogService.catalog(modifyRlsParameters.catalogVersion());
            if (modifyRlsParameters.securityEnabled()) {
                this.updatePolicies(catalog, modifyRlsParameters.tableId());
            } else {
                this.disableRls(catalog, modifyRlsParameters.tableId());
            }
        }
        return CompletableFuture.completedFuture(false);
    }

    private CompletableFuture<Boolean> onTableCreated(CreateTableEventParameters parameters) {
        Catalog catalog = this.catalogService.catalog(parameters.catalogVersion());
        if (parameters.tableDescriptor().securityEnabled()) {
            this.updatePolicies(catalog, parameters.tableId());
        } else {
            this.disableRls(catalog, parameters.tableId());
        }
        return CompletableFuture.completedFuture(false);
    }

    private CompletableFuture<Boolean> onTableDropped(DropTableEventParameters parameters) {
        Catalog catalog = this.catalogService.catalog(parameters.catalogVersion() - 1);
        CatalogTableDescriptor descriptor = catalog.table(parameters.tableId());
        if (descriptor == null) {
            return CompletableFuture.completedFuture(false);
        }
        this.destructionEventsQueue.enqueue((Object)new DestroyTableEvent(parameters.catalogVersion(), parameters.tableId()));
        return CompletableFuture.completedFuture(false);
    }

    private CompletableFuture<Boolean> onTablePolicyAdded(CreateTablePolicyEventParameters parameters) {
        CatalogTableDescriptor tableDescriptor;
        Catalog catalog = this.catalogService.catalog(parameters.catalogVersion());
        if (catalog.policy(parameters.descriptor().id()) != null && (tableDescriptor = catalog.table(parameters.descriptor().tableId())) != null && tableDescriptor.securityEnabled()) {
            this.updatePolicies(catalog, tableDescriptor.id());
        }
        return CompletableFuture.completedFuture(false);
    }

    private CompletableFuture<Boolean> onTablePolicyDropped(DropTablePolicyEventParameters parameters) {
        CatalogTableDescriptor tableDescriptor;
        Catalog catalog = this.catalogService.catalog(parameters.catalogVersion());
        Catalog previousCatalog = this.catalogService.catalog(parameters.catalogVersion() - 1);
        CatalogTablePolicyDescriptor policyDescriptor = previousCatalog.policy(parameters.policyId());
        if (policyDescriptor != null && (tableDescriptor = catalog.table(policyDescriptor.tableId())) != null && tableDescriptor.securityEnabled()) {
            this.updatePolicies(catalog, tableDescriptor.id());
        }
        return CompletableFuture.completedFuture(false);
    }

    private void updatePolicies(Catalog catalog, int tableId) {
        RlsCheckerChain latest = (RlsCheckerChain)this.checkers.get(tableId);
        RlsCheckerChain next = this.convertPolicies(catalog, tableId, latest);
        RlsCheckerChain old = this.checkers.put(tableId, next);
        assert (old == latest);
    }

    private RlsCheckerChain convertPolicies(Catalog catalog, int tableId, @Nullable RlsCheckerChain latest) {
        List policyDescriptors = catalog.policies(tableId);
        if (policyDescriptors.isEmpty()) {
            return new AllowForSystemUserChecker(catalog.time(), latest);
        }
        HashSet allowAllPolicyRoles = null;
        Predicate<String> allowAllPolicyRoleMatcher = null;
        ArrayList<RlsPolicy> policies = new ArrayList<RlsPolicy>();
        for (CatalogTablePolicyDescriptor policyDescriptor : policyDescriptors) {
            switch (policyDescriptor.predicate().type()) {
                case ALWAYS_TRUE: {
                    if (allowAllPolicyRoleMatcher != null) break;
                    if (policyDescriptor.roles().isEmpty()) {
                        allowAllPolicyRoleMatcher = ALL_MATCHES;
                        allowAllPolicyRoles = null;
                        break;
                    }
                    if (allowAllPolicyRoles == null) {
                        allowAllPolicyRoles = new HashSet();
                    }
                    allowAllPolicyRoles.addAll(policyDescriptor.roles());
                    break;
                }
                case CURRENT_USER: {
                    String columnName = ((CatalogTablePolicyPredicate.CurrentUserPolicyPredicate)policyDescriptor.predicate()).columnName();
                    Set roles = policyDescriptor.roles();
                    Predicate<String> roleMatcher = roles.isEmpty() ? ALL_MATCHES : roles::contains;
                    policies.add(new RlsPolicy(roleMatcher, columnName));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Predicate is not supported: " + policyDescriptor.predicate().type()));
                }
            }
        }
        if (allowAllPolicyRoleMatcher == null) {
            allowAllPolicyRoleMatcher = allowAllPolicyRoles != null ? allowAllPolicyRoles::contains : NONE_MATCHES;
        }
        VersionResolver resolver = ts -> {
            Catalog activeCatalog = this.catalogService.activeCatalog(ts);
            assert (activeCatalog != null);
            CatalogTableDescriptor table = activeCatalog.table(tableId);
            assert (table != null);
            return table.latestSchemaVersion();
        };
        return new PolicyBasedChecker(resolver, allowAllPolicyRoleMatcher, List.copyOf(policies), this.schemaManager.schemaRegistry(tableId), catalog.time(), latest);
    }

    private void disableRls(Catalog catalog, int tableId) {
        RlsCheckerChain latest = (RlsCheckerChain)this.checkers.get(tableId);
        AllowForAllChecker next = new AllowForAllChecker(catalog.time(), latest);
        RlsCheckerChain old = this.checkers.put(tableId, next);
        assert (old == latest);
    }

    private CompletableFuture<Boolean> onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        long newWatermark = parameters.newLowWatermark().longValue();
        int newEarliestCatalogVersion = this.catalogService.activeCatalogVersion(newWatermark);
        this.cleanUpExecutor.execute(() -> {
            this.destructionEventsQueue.drainUpTo((long)newEarliestCatalogVersion).forEach(event -> this.checkers.remove(event.tableId()));
            this.checkers.values().forEach(checker -> checker.trim(newWatermark));
        });
        return CompletableFuture.completedFuture(false);
    }

    private /* synthetic */ void lambda$recoverState$2(Int2ObjectMap statesByTableId, Catalog catalog, int tableId) {
        statesByTableId.remove(tableId);
        this.destructionEventsQueue.enqueue((Object)new DestroyTableEvent(catalog.version(), tableId));
    }

    private static class DestroyTableEvent {
        final int catalogVersion;
        final int tableId;

        DestroyTableEvent(int catalogVersion, int tableId) {
            this.catalogVersion = catalogVersion;
            this.tableId = tableId;
        }

        int catalogVersion() {
            return this.catalogVersion;
        }

        int tableId() {
            return this.tableId;
        }
    }
}

