/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.partition;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.Partition;
import org.apache.ignite.table.partition.PartitionDistribution;
import org.apache.ignite.table.partition.PartitionManager;

public class PublicApiThreadingPartitionManager
implements PartitionManager {
    private final PartitionDistribution partitionDistribution;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingPartitionManager(PartitionDistribution partitionDistribution, Executor asyncContinuationExecutor) {
        this.partitionDistribution = partitionDistribution;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public CompletableFuture<List<Partition>> partitionsAsync() {
        return this.preventThreadHijack(this.partitionDistribution.partitionsAsync());
    }

    public List<Partition> partitions() {
        return this.partitionDistribution.partitions();
    }

    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        return this.preventThreadHijack(this.partitionDistribution.primaryReplicaAsync(partition));
    }

    public ClusterNode primaryReplica(Partition partition) {
        return this.partitionDistribution.primaryReplica(partition);
    }

    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        return this.preventThreadHijack(this.partitionDistribution.primaryReplicasAsync());
    }

    public CompletableFuture<List<Partition>> primaryReplicasAsync(ClusterNode node) {
        return this.preventThreadHijack(this.partitionDistribution.primaryReplicasAsync(node));
    }

    public Map<Partition, ClusterNode> primaryReplicas() {
        return this.partitionDistribution.primaryReplicas();
    }

    public List<Partition> primaryReplicas(ClusterNode node) {
        return this.partitionDistribution.primaryReplicas(node);
    }

    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        return this.preventThreadHijack(this.partitionDistribution.partitionAsync(key, mapper));
    }

    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        return this.preventThreadHijack(this.partitionDistribution.partitionAsync(key));
    }

    public <K> Partition partition(K key, Mapper<K> mapper) {
        return this.partitionDistribution.partition(key, mapper);
    }

    public Partition partition(Tuple key) {
        return this.partitionDistribution.partition(key);
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, (Executor)this.asyncContinuationExecutor);
    }
}

