/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.partition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerImpl;
import org.apache.ignite.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.partition.HashPartition;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.Partition;
import org.apache.ignite.table.partition.PartitionManager;

public class HashPartitionManagerImpl
implements PartitionManager {
    private final InternalTable table;
    private final SchemaRegistry schemaReg;
    private final MarshallersProvider marshallers;

    public HashPartitionManagerImpl(InternalTable table, SchemaRegistry schemaReg, MarshallersProvider marshallers) {
        this.table = table;
        this.schemaReg = schemaReg;
        this.marshallers = marshallers;
    }

    public CompletableFuture<List<Partition>> partitionsAsync() {
        return CompletableFuture.completedFuture(this.partitions());
    }

    public List<Partition> partitions() {
        int partitions = this.table.partitions();
        ArrayList<Partition> list = new ArrayList<Partition>(partitions);
        for (int i = 0; i < partitions; ++i) {
            list.add((Partition)new HashPartition(i));
        }
        return list;
    }

    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        int partitions = this.table.partitions();
        CompletableFuture[] futures = new CompletableFuture[partitions];
        for (int i = 0; i < partitions; ++i) {
            futures[i] = this.table.partitionLocation(i);
        }
        return CompletableFuture.allOf(futures).thenApply(unused -> {
            HashMap<HashPartition, ClusterNode> result = new HashMap<HashPartition, ClusterNode>(partitions);
            for (int i = 0; i < partitions; ++i) {
                result.put(new HashPartition(i), ((InternalClusterNode)futures[i].join()).toPublicNode());
            }
            return result;
        });
    }

    public CompletableFuture<List<Partition>> primaryReplicasAsync(ClusterNode node) {
        return this.primaryReplicasAsync().thenApply(map -> {
            ArrayList<Partition> parts = new ArrayList<Partition>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (!((ClusterNode)entry.getValue()).equals(node)) continue;
                parts.add((Partition)entry.getKey());
            }
            return parts;
        });
    }

    public Map<Partition, ClusterNode> primaryReplicas() {
        return (Map)ViewUtils.sync(this.primaryReplicasAsync());
    }

    public List<Partition> primaryReplicas(ClusterNode node) {
        return (List)ViewUtils.sync(this.primaryReplicasAsync(node));
    }

    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        return this.table.partitionLocation(Math.toIntExact(partition.id())).thenApply(InternalClusterNode::toPublicNode);
    }

    public ClusterNode primaryReplica(Partition partition) {
        return (ClusterNode)ViewUtils.sync(this.primaryReplicaAsync(partition));
    }

    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mapper);
        SchemaDescriptor schema = this.schemaReg.lastKnownSchema();
        Column valCol = (Column)CollectionUtils.first((List)schema.valueColumns());
        assert (valCol != null);
        KvMarshallerImpl marshaller = new KvMarshallerImpl(schema, this.marshallers, mapper, Mapper.of(Void.class, (String)valCol.name()));
        Row keyRow = marshaller.marshal(key);
        return CompletableFuture.completedFuture(new HashPartition(this.table.partitionId((BinaryRowEx)keyRow)));
    }

    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        Objects.requireNonNull(key);
        Row keyRow = new TupleMarshallerImpl(this.table::name, this.schemaReg.lastKnownSchema()).marshalKey(key);
        return CompletableFuture.completedFuture(new HashPartition(this.table.partitionId((BinaryRowEx)keyRow)));
    }

    public <K> Partition partition(K key, Mapper<K> mapper) {
        return (Partition)ViewUtils.sync(this.partitionAsync(key, mapper));
    }

    public Partition partition(Tuple key) {
        return (Partition)ViewUtils.sync(this.partitionAsync(key));
    }
}

