/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.expiration.metrics;

import java.util.List;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.AtomicLongMetric;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.table.distributed.expiration.metrics.DetailedExpirationMetric;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ExpirationMetricSource
extends AbstractMetricSource<Holder> {
    public static final String NAME = "expiration";

    public ExpirationMetricSource() {
        super(NAME);
    }

    public void addDeletedExpiredRowsCnt(String tableName, int tableId, int partitionId, long delta) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.totalDeletedExpiredRowsCnt.add(delta);
            holder.detailedDeletedExpiredRowsMetric.add(tableName, tableId, partitionId, delta);
        }
    }

    public void remove(int tableId, int partitionId) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.detailedDeletedExpiredRowsMetric.remove(tableId, partitionId);
        }
    }

    public void remove(int tableId) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.detailedDeletedExpiredRowsMetric.remove(tableId);
        }
    }

    protected Holder createHolder() {
        return new Holder();
    }

    @TestOnly
    @Nullable
    public AtomicLongMetric totalDeletedExpiredRowsMetric() {
        Holder holder = (Holder)this.holder();
        return holder != null ? holder.totalDeletedExpiredRowsCnt : null;
    }

    @TestOnly
    @Nullable
    public DetailedExpirationMetric detailedDeletedExpiredRowsMetric() {
        Holder holder = (Holder)this.holder();
        return holder != null ? holder.detailedDeletedExpiredRowsMetric : null;
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final AtomicLongMetric totalDeletedExpiredRowsCnt = new AtomicLongMetric("TotalDeletedExpiredRowsCount", "Total number of deleted expired rows.");
        private final DetailedExpirationMetric detailedDeletedExpiredRowsMetric = new DetailedExpirationMetric("DetailedExpirationMetrics", "Detailed expiration metrics.");

        protected Holder() {
        }

        public Iterable<Metric> metrics() {
            return List.of(this.totalDeletedExpiredRowsCnt, this.detailedDeletedExpiredRowsMetric);
        }
    }
}

