/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.table.distributed.disaster.exceptions.RemoteOperationException;
import org.jetbrains.annotations.Nullable;

class MultiNodeOperations {
    private final Map<UUID, CompletableFuture<Void>> operationsById = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();

    MultiNodeOperations() {
    }

    void add(UUID operationId, CompletableFuture<Void> operationFuture) {
        this.operationsById.put(operationId, operationFuture);
    }

    CompletableFuture<Void> remove(UUID operationId) {
        return this.operationsById.remove(operationId);
    }

    void completeAllExceptionally(String nodeName, Throwable e) {
        Set<UUID> operationIds = Set.copyOf(this.operationsById.keySet());
        for (UUID operationId : operationIds) {
            CompletableFuture<Void> operation = this.operationsById.remove(operationId);
            if (operation == null) continue;
            operation.completeExceptionally((Throwable)((Object)new RemoteOperationException(e.getMessage(), nodeName)));
        }
    }

    public void complete(UUID operationId, String nodeName, @Nullable String exceptionMessage) {
        CompletableFuture<Void> operationFuture = this.operationsById.remove(operationId);
        if (operationFuture != null) {
            if (exceptionMessage != null) {
                operationFuture.completeExceptionally((Throwable)((Object)new RemoteOperationException(exceptionMessage, nodeName)));
            } else {
                operationFuture.complete(null);
            }
        }
    }

    public boolean isEmpty() {
        return this.operationsById.isEmpty();
    }
}

