/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.table.distributed.disaster.ManualGroupRestartRequest;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

class ManualGroupRestartRequestSerializer
extends VersionedSerializer<ManualGroupRestartRequest> {
    private static final int UNDEFINED_TABLE_ID = -1;
    static final ManualGroupRestartRequestSerializer INSTANCE = new ManualGroupRestartRequestSerializer();

    ManualGroupRestartRequestSerializer() {
    }

    protected byte getProtocolVersion() {
        return 3;
    }

    protected void writeExternalData(ManualGroupRestartRequest request, IgniteDataOutput out) throws IOException {
        Objects.requireNonNull(request.coordinator(), "Coordinator must not be null");
        out.writeUuid(request.operationId());
        out.writeVarInt((long)request.zoneId());
        out.writeVarInt(-1L);
        ManualGroupRestartRequestSerializer.writeVarIntSet(request.partitionIds(), (IgniteDataOutput)out);
        ManualGroupRestartRequestSerializer.writeStringSet(request.nodeNames(), (IgniteDataOutput)out);
        HybridTimestamp.hybridTimestamp((long)request.assignmentsTimestamp()).writeTo(out);
        out.writeBoolean(request.cleanUp());
        out.writeUTF(request.coordinator());
    }

    protected ManualGroupRestartRequest readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        UUID operationId = in.readUuid();
        int zoneId = in.readVarIntAsInt();
        in.readVarIntAsInt();
        Set partitionIds = ManualGroupRestartRequestSerializer.readVarIntSet((IgniteDataInput)in);
        Set nodeNames = ManualGroupRestartRequestSerializer.readStringSet((IgniteDataInput)in);
        HybridTimestamp assignmentsTimestamp = HybridTimestamp.readFrom((IgniteDataInput)in);
        boolean cleanUp = false;
        if (protoVer >= 2) {
            cleanUp = in.readBoolean();
        }
        String coordinator = ManualGroupRestartRequestSerializer.readCoordinator(protoVer, in);
        return new ManualGroupRestartRequest(operationId, zoneId, partitionIds, nodeNames, assignmentsTimestamp.longValue(), cleanUp, coordinator);
    }

    @Nullable
    private static String readCoordinator(byte protoVer, IgniteDataInput in) throws IOException {
        return protoVer >= 3 ? in.readUTF() : null;
    }
}

