/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite.internal.partition.replicator.raft.RaftTableProcessor;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionMvStorageAccess;
import org.apache.ignite.internal.raft.ExecutorInclinedRaftCommandRunner;
import org.apache.ignite.internal.raft.service.RaftCommandRunner;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.secondarystoragebridge.SecondaryStorageBridge;
import org.apache.ignite.internal.secondarystoragebridge.UpdatesStorage;
import org.apache.ignite.internal.storage.secondary.SecondaryStorage;
import org.apache.ignite.internal.storage.secondary.SecondaryTableStorage;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.raft.SecondaryPartitionListener;
import org.apache.ignite.internal.table.distributed.replicator.SecondaryPartitionReplicaListener;
import org.apache.ignite.internal.table.distributed.storage.InternalTableImpl;
import org.apache.ignite.internal.table.distributed.storage.SecondaryStoragePartitionAccess;
import org.apache.ignite.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.util.SafeTimeValuesTracker;

class SecondaryZoneManager {
    private final PartitionReplicaLifecycleManager partitionReplicaLifecycleManager;
    private final SecondaryStorageBridge secondaryStorageBridge;
    private final RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry;
    private final LowWatermark lowWatermark;
    private final IgniteSpinBusyLock busyLock;
    private final Executor partitionOperationsExecutor;

    SecondaryZoneManager(PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, SecondaryStorageBridge secondaryStorageBridge, RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry, LowWatermark lowWatermark, IgniteSpinBusyLock busyLock, Executor partitionOperationsExecutor) {
        this.partitionReplicaLifecycleManager = partitionReplicaLifecycleManager;
        this.secondaryStorageBridge = secondaryStorageBridge;
        this.remotelyTriggeredResourceRegistry = remotelyTriggeredResourceRegistry;
        this.lowWatermark = lowWatermark;
        this.busyLock = busyLock;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
    }

    void loadTableToSecondaryZoneOnTableCreateHavingZoneReadLock(long causalityToken, TableViewInternal table, CatalogZoneDescriptor secondaryZoneDescriptor, CatalogTableDescriptor tableDescriptor) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            for (int partitionIndex = 0; partitionIndex < secondaryZoneDescriptor.partitions(); ++partitionIndex) {
                ZonePartitionId zonePartitionId = new ZonePartitionId(secondaryZoneDescriptor.id(), partitionIndex);
                if (!this.partitionReplicaLifecycleManager.hasLocalPartition(zonePartitionId)) continue;
                this.prepareSecondaryPartitionResourcesAndLoadToZoneReplica(table, zonePartitionId, false);
            }
        });
    }

    CompletableFuture<Void> unloadTableResourcesFromSecondaryZoneReplicaHavingZoneReadLock(TableViewInternal table) {
        int tableId = table.tableId();
        InternalTable internalTable = table.internalTable();
        int partitions = internalTable.partitions();
        Integer secondaryZoneId = internalTable.secondaryZoneId();
        assert (secondaryZoneId != null) : "Secondary zone is null [tableId=" + tableId + "]";
        CompletableFuture[] unloadFutures = new CompletableFuture[partitions];
        for (int partitionIndex = 0; partitionIndex < partitions; ++partitionIndex) {
            ZonePartitionId zonePartitionId = new ZonePartitionId(secondaryZoneId.intValue(), partitionIndex);
            unloadFutures[partitionIndex] = this.partitionReplicaLifecycleManager.unloadTableResourcesFromZoneReplica(zonePartitionId, tableId);
        }
        return CompletableFuture.allOf(unloadFutures);
    }

    void prepareSecondaryPartitionResourcesAndLoadToZoneReplica(TableViewInternal table, ZonePartitionId zonePartitionId, boolean onNodeRecovery) {
        int tableId = table.tableId();
        int partitionId = zonePartitionId.partitionId();
        InternalTableImpl internalTable = (InternalTableImpl)table.internalTable();
        SafeTimeValuesTracker safeTimeTracker = new SafeTimeValuesTracker(HybridTimestamp.MIN_VALUE);
        internalTable.updateSecondaryPartitionTrackers(partitionId, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker);
        SecondaryTableStorage secondaryTableStorage = internalTable.secondaryStorage();
        assert (secondaryTableStorage != null) : "No secondary storage for table " + tableId;
        SecondaryStorage secondaryStorage = secondaryTableStorage.getOrCreatePartition(partitionId);
        SecondaryPartitionListener raftGroupListener = new SecondaryPartitionListener(secondaryStorage, this.secondaryStorageBridge, tableId, partitionId, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker);
        PartitionReplicaLifecycleManager.TablePartitionReplicaProcessorFactory createListener = (raftClient, txStateResolver) -> this.createSecondaryReplicaListener(zonePartitionId, raftClient, secondaryStorage, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker);
        PartitionKey partitionKey = new PartitionKey(zonePartitionId.zoneId(), partitionId);
        UpdatesStorage updatesStorage = this.secondaryStorageBridge.getOrCreateUpdatesStorage(tableId, partitionId);
        this.partitionReplicaLifecycleManager.loadTableListenerToZoneReplica(zonePartitionId, tableId, createListener, (RaftTableProcessor)raftGroupListener, (PartitionMvStorageAccess)new SecondaryStoragePartitionAccess(partitionKey, tableId, updatesStorage), onNodeRecovery);
    }

    private SecondaryPartitionReplicaListener createSecondaryReplicaListener(ZonePartitionId zonePartitionId, RaftCommandRunner raftClient, SecondaryStorage secondaryStorage, PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker) {
        return new SecondaryPartitionReplicaListener((ReplicationGroupId)zonePartitionId, (RaftCommandRunner)new ExecutorInclinedRaftCommandRunner(raftClient, this.partitionOperationsExecutor), secondaryStorage, safeTimeTracker, this.remotelyTriggeredResourceRegistry, this.lowWatermark);
    }
}

