/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.metrics;

import java.util.List;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.LongAdderMetric;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.table.QualifiedName;

public class TableMetricSource
extends AbstractMetricSource<Holder> {
    public static final String SOURCE_NAME = "tables";
    public static final String RO_READS = "RoReads";
    public static final String RW_READS = "RwReads";
    public static final String WRITES = "Writes";
    private final QualifiedName tableName;

    public TableMetricSource(QualifiedName tableName) {
        super(TableMetricSource.sourceName(tableName), "Table metrics.", SOURCE_NAME);
        this.tableName = tableName;
    }

    public static String sourceName(QualifiedName tableName) {
        return "tables." + tableName.toCanonicalForm();
    }

    public QualifiedName qualifiedTableName() {
        return this.tableName;
    }

    public void onRead(boolean readOnly) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            if (readOnly) {
                holder.roReads.increment();
            } else {
                holder.rwReads.increment();
            }
        }
    }

    public void onRead(int x, boolean readOnly) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            if (readOnly) {
                holder.roReads.add((long)x);
            } else {
                holder.rwReads.add((long)x);
            }
        }
    }

    public void onWrite() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.writes.increment();
        }
    }

    public void onWrite(int x) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.writes.add((long)x);
        }
    }

    protected Holder createHolder() {
        return new Holder();
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final LongAdderMetric roReads = new LongAdderMetric("RoReads", "The total number of reads executed within read-write transactions.");
        private final LongAdderMetric rwReads = new LongAdderMetric("RwReads", "The total number of reads executed within read-only transactions.");
        private final LongAdderMetric writes = new LongAdderMetric("Writes", "The total number of writes executed within read-write transactions.");
        private final List<Metric> metrics = List.of(this.roReads, this.rwReads, this.writes);

        protected Holder() {
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

