/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.message;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.table.message.PartitionModificationInfoMessage;
import org.apache.ignite.internal.table.message.PartitionModificationInfoMessageBuilder;
import org.apache.ignite.internal.table.message.TableMessagesFactory;
import org.apache.ignite.internal.table.message.TableMessagesTypeInfos;

class PartitionModificationInfoMessageDeserializer
implements MessageDeserializer<PartitionModificationInfoMessage> {
    private final PartitionModificationInfoMessageBuilder msg;

    PartitionModificationInfoMessageDeserializer(TableMessagesFactory messageFactory) {
        this.msg = messageFactory.partitionModificationInfoMessage();
    }

    public Class<PartitionModificationInfoMessage> klass() {
        return PartitionModificationInfoMessage.class;
    }

    public PartitionModificationInfoMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TableMessagesTypeInfos.partitionModificationInfoMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("estimatedSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.estimatedSize(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("lastModificationCounter");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastModificationCounter(tmp);
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("partId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partId(tmp);
                reader.incrementState();
            }
            case 3: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(PartitionModificationInfoMessage.class);
    }
}

