/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.storage;

import java.util.Collections;
import java.util.Set;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.table.distributed.storage.NullMvTableStorage;
import org.gridgain.internal.license.LicenseFeature;
import org.jetbrains.annotations.Nullable;

public class NullStorageEngine
implements StorageEngine {
    public String name() {
        return "null";
    }

    public void start() throws StorageException {
    }

    public void stop() throws StorageException {
    }

    public boolean isVolatile() {
        return (Boolean)NullStorageEngine.throwNoEngineException(null);
    }

    public MvTableStorage createMvTable(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) {
        return new NullMvTableStorage(tableDescriptor);
    }

    public void destroyMvTable(int tableId) {
        NullStorageEngine.throwNoEngineException(tableId);
    }

    @Nullable
    public LicenseFeature licenseFeature() {
        return null;
    }

    public boolean hasConfiguredStorageProfiles() {
        return false;
    }

    private static <T> T throwNoEngineException(@Nullable Integer tableId) {
        throw new StorageException("Table uses an unknown storage profile or engine, so current node either should not receive any assignments, or storage profile addition is not handled properly" + (String)(tableId == null ? "" : " [tableId=" + tableId + "]"));
    }

    public Set<Integer> tableIdsOnDisk() {
        return Collections.emptySet();
    }
}

