/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.schema;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.raft.util.DefaultByteBuffersPool;
import org.apache.ignite.internal.raft.util.OptimizedMarshaller;
import org.apache.ignite.internal.table.distributed.schema.PartitionCommandsMarshaller;
import org.apache.ignite.internal.table.distributed.schema.PartitionCommandsMarshallerImpl;

public class ThreadLocalPartitionCommandsMarshaller
implements PartitionCommandsMarshaller {
    private final ThreadLocal<PartitionCommandsMarshaller> marshaller;
    private final OptimizedMarshaller.ByteBuffersPool pool = new DefaultByteBuffersPool(Runtime.getRuntime().availableProcessors());

    public ThreadLocalPartitionCommandsMarshaller(MessageSerializationRegistry serializationRegistry) {
        this.marshaller = ThreadLocal.withInitial(() -> new PartitionCommandsMarshallerImpl(serializationRegistry, this.pool));
    }

    public void patch(ByteBuffer raw, HybridTimestamp safeTs) {
        this.marshaller.get().patch(raw, safeTs);
    }

    public byte[] marshall(Object o) {
        return this.marshaller.get().marshall(o);
    }

    public <T> T unmarshall(ByteBuffer bytes) {
        return (T)this.marshaller.get().unmarshall(bytes);
    }

    @Override
    public int readRequiredCatalogVersion(ByteBuffer raw) {
        return this.marshaller.get().readRequiredCatalogVersion(raw);
    }

    @Override
    public long readSafeTimestamp(ByteBuffer raw) {
        return this.marshaller.get().readSafeTimestamp(raw);
    }
}

