/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.network.command.ArchiveAllCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommand;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommand;
import org.apache.ignite.internal.partition.replicator.raft.CommandResult;
import org.apache.ignite.internal.partition.replicator.raft.RaftTableProcessor;
import org.apache.ignite.internal.partition.replicator.raft.handlers.AbstractCommandHandler;
import org.apache.ignite.internal.partition.replicator.raft.handlers.CommandHandlers;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite.internal.placementdriver.LeasePlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.ReadCommand;
import org.apache.ignite.internal.raft.WriteCommand;
import org.apache.ignite.internal.raft.service.CommandClosure;
import org.apache.ignite.internal.raft.service.RaftGroupListener;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.command.SafeTimePropagatingCommand;
import org.apache.ignite.internal.replicator.command.SafeTimeSyncCommand;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommand;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.table.distributed.StorageUpdateHandler;
import org.apache.ignite.internal.table.distributed.TableUtils;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.raft.MinimumRequiredTimeCollectorService;
import org.apache.ignite.internal.table.distributed.raft.handlers.BuildIndexCommandHandler;
import org.apache.ignite.internal.table.distributed.raft.handlers.MinimumActiveTxTimeCommandHandler;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.UpdateCommandResult;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.util.SafeTimeValuesTracker;
import org.apache.ignite.internal.util.TrackerClosedException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PartitionListener
implements RaftGroupListener,
RaftTableProcessor {
    private static final IgniteLogger LOG = Loggers.forClass(PartitionListener.class);
    private final TxManager txManager;
    private final PartitionDataStorage storage;
    private final StorageUpdateHandler storageUpdateHandler;
    private final SafeTimeValuesTracker safeTimeTracker;
    private final CatalogService catalogService;
    private final UUID localNodeId;
    private final Set<String> currentGroupTopology = new HashSet<String>();
    private final CommandHandlers commandHandlers;
    private final LeasePlacementDriver placementDriver;
    private final ClockService clockService;
    private final ZonePartitionId realReplicationGroupId;
    private ReplicaMeta lastKnownLease;

    public PartitionListener(TxManager txManager, PartitionDataStorage partitionDataStorage, StorageUpdateHandler storageUpdateHandler, SafeTimeValuesTracker safeTimeTracker, CatalogService catalogService, SchemaRegistry schemaRegistry, IndexMetaStorage indexMetaStorage, UUID localNodeId, MinimumRequiredTimeCollectorService minTimeCollectorService, Executor partitionOperationsExecutor, LeasePlacementDriver placementDriver, ClockService clockService, ZonePartitionId realReplicationGroupId) {
        this.txManager = txManager;
        this.storage = partitionDataStorage;
        this.storageUpdateHandler = storageUpdateHandler;
        this.safeTimeTracker = safeTimeTracker;
        this.catalogService = catalogService;
        this.localNodeId = localNodeId;
        this.placementDriver = placementDriver;
        this.clockService = clockService;
        this.realReplicationGroupId = realReplicationGroupId;
        TablePartitionId tablePartitionId = new TablePartitionId(this.storage.tableId(), this.storage.partitionId());
        CommandHandlers.Builder commandHandlersBuilder = new CommandHandlers.Builder();
        commandHandlersBuilder.addHandler((short)9, (short)45, (AbstractCommandHandler)new MinimumActiveTxTimeCommandHandler(this.storage, tablePartitionId, minTimeCollectorService));
        BuildIndexCommandHandler buildIndexCommandHandler = new BuildIndexCommandHandler(this.storage, indexMetaStorage, storageUpdateHandler, schemaRegistry);
        commandHandlersBuilder.addHandler((short)9, (short)44, (AbstractCommandHandler)buildIndexCommandHandler);
        commandHandlersBuilder.addHandler((short)9, (short)51, (AbstractCommandHandler)buildIndexCommandHandler);
        this.commandHandlers = commandHandlersBuilder.build();
        RaftGroupConfiguration committedGroupConfiguration = this.storage.committedGroupConfiguration();
        if (committedGroupConfiguration != null) {
            this.setCurrentGroupTopology(committedGroupConfiguration);
        }
    }

    private boolean shouldUpdateStorage(boolean isFull, LeaseInfo storageLeaseInfo) {
        if (isFull) {
            return true;
        }
        HybridTimestamp currentTime = this.clockService.current();
        if (this.lastKnownLease == null || this.lastKnownLease.getExpirationTime().compareTo(currentTime) < 0) {
            this.lastKnownLease = this.placementDriver.getCurrentPrimaryReplica((ReplicationGroupId)this.realReplicationGroupId, currentTime);
        }
        if (this.lastKnownLease == null || !this.lastKnownLease.getLeaseholderId().equals(this.localNodeId)) {
            return true;
        }
        return !this.localNodeId.equals(storageLeaseInfo.primaryReplicaNodeId());
    }

    public void onRead(Iterator<CommandClosure<ReadCommand>> iterator) {
        iterator.forEachRemaining(clo -> {
            Command command = clo.command();
            assert (false) : "No read commands expected, [cmd=" + command + "]";
        });
    }

    public void onWrite(Iterator<CommandClosure<WriteCommand>> iterator) {
        iterator.forEachRemaining(clo -> {
            CommandResult result;
            WriteCommand command = (WriteCommand)clo.command();
            long commandIndex = clo.index();
            long commandTerm = clo.term();
            @Nullable HybridTimestamp safeTimestamp = clo.safeTimestamp();
            assert (safeTimestamp == null || command instanceof SafeTimePropagatingCommand) : command;
            this.checkCommandIndex(commandIndex);
            this.storage.acquirePartitionSnapshotsReadLock();
            try {
                result = this.processCommand(command, commandIndex, commandTerm, safeTimestamp);
            }
            catch (Throwable t) {
                LOG.error("Got error while processing command [commandIndex={}, commandTerm={}, command={}]", t, new Object[]{clo.index(), clo.index(), command});
                clo.result((Serializable)t);
                throw t;
            }
            finally {
                this.storage.releasePartitionSnapshotsReadLock();
            }
            clo.result(result.result());
        });
    }

    public CommandResult processCommand(WriteCommand command, long commandIndex, long commandTerm, @Nullable HybridTimestamp safeTimestamp) {
        CommandResult result = null;
        AbstractCommandHandler commandHandler = this.commandHandlers.handler(command.groupType(), command.messageType());
        if (commandHandler != null) {
            result = commandHandler.handle(command, commandIndex, commandTerm, safeTimestamp);
        } else if (command instanceof UpdateCommand) {
            result = this.handleUpdateCommand((UpdateCommand)command, commandIndex, commandTerm, safeTimestamp);
        } else if (command instanceof UpdateAllCommand) {
            result = this.handleUpdateAllCommand((UpdateAllCommand)command, commandIndex, commandTerm, safeTimestamp);
        } else if (command instanceof WriteIntentSwitchCommand) {
            result = this.handleWriteIntentSwitchCommand((WriteIntentSwitchCommand)command, commandIndex, commandTerm);
        } else if (command instanceof SafeTimeSyncCommand) {
            result = this.handleSafeTimeSyncCommand((SafeTimeSyncCommand)command, commandIndex, commandTerm);
        } else if (command instanceof PrimaryReplicaChangeCommand) {
            result = this.handlePrimaryReplicaChangeCommand((PrimaryReplicaChangeCommand)command, commandIndex, commandTerm);
        }
        if (result == null) {
            throw new AssertionError((Object)("Unknown command type [command=" + command.toStringForLightLogging() + "]"));
        }
        if (result.wasApplied() && safeTimestamp != null) {
            PartitionListener.updateTrackerIgnoringTrackerClosedException(this.safeTimeTracker, safeTimestamp);
        }
        return result;
    }

    public void initialize(@Nullable RaftGroupConfiguration config, @Nullable LeaseInfo leaseInfo, long lastAppliedIndex, long lastAppliedTerm) {
        assert (this.storage.lastAppliedIndex() == 0L || this.storage.lastAppliedIndex() >= lastAppliedIndex) : String.format("Trying to initialize a non-empty storage with data with a greater applied index: storageLastAppliedIndex=%d, lastAppliedIndex=%d", this.storage.lastAppliedIndex(), lastAppliedIndex);
        if (lastAppliedIndex <= this.storage.lastAppliedIndex()) {
            return;
        }
        this.storage.runConsistently(locker -> {
            if (config != null) {
                this.setCurrentGroupTopology(config);
                this.storage.committedGroupConfiguration(config);
            }
            if (leaseInfo != null) {
                this.storage.updateLease(leaseInfo);
            }
            this.storage.lastApplied(lastAppliedIndex, lastAppliedTerm);
            return null;
        });
        this.storage.flush();
    }

    private void checkCommandIndex(long commandIndex) {
        long storagesAppliedIndex = this.storage.lastAppliedIndex();
        assert (commandIndex > storagesAppliedIndex) : "Write command must have an index greater than that of storages [commandIndex=" + commandIndex + ", mvAppliedIndex=" + this.storage.lastAppliedIndex() + "]";
    }

    private CommandResult handleUpdateCommand(UpdateCommand cmd, long commandIndex, long commandTerm, HybridTimestamp safeTimestamp) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        LeaseInfo storageLeaseInfo = this.storage.leaseInfo();
        if (cmd.leaseStartTime() != null) {
            long leaseStartTime = cmd.leaseStartTime();
            if (storageLeaseInfo == null || leaseStartTime != storageLeaseInfo.leaseStartTime()) {
                UpdateCommandResult updateCommandResult = new UpdateCommandResult(false, Long.valueOf(storageLeaseInfo == null ? 0L : storageLeaseInfo.leaseStartTime()), this.isPrimaryInGroupTopology(storageLeaseInfo), 0L);
                return new CommandResult((Serializable)updateCommandResult, false);
            }
        }
        UUID txId = cmd.txId();
        assert (storageLeaseInfo != null);
        assert (this.localNodeId != null);
        if (this.shouldUpdateStorage(cmd.full(), storageLeaseInfo)) {
            this.storageUpdateHandler.handleUpdate(txId, cmd.rowUuid(), cmd.commitPartitionId().asReplicationGroupId(), cmd.rowToUpdate(), !cmd.full(), () -> this.storage.lastApplied(commandIndex, commandTerm), (HybridTimestamp)(cmd.full() ? safeTimestamp : null), cmd.lastCommitTimestamp(), TableUtils.indexIdsAtRwTxBeginTs(this.catalogService, txId, this.storage.tableId()));
        } else {
            this.advanceLastAppliedIndexConsistently(commandIndex, commandTerm);
        }
        this.replicaTouch(txId, cmd.txCoordinatorId(), (HybridTimestamp)(cmd.full() ? safeTimestamp : null), cmd.full());
        return new CommandResult((Serializable)new UpdateCommandResult(true, this.isPrimaryInGroupTopology(storageLeaseInfo), safeTimestamp.longValue()), true);
    }

    private CommandResult handleUpdateAllCommand(UpdateAllCommand cmd, long commandIndex, long commandTerm, HybridTimestamp safeTimestamp) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        LeaseInfo storageLeaseInfo = this.storage.leaseInfo();
        if (cmd.leaseStartTime() != null) {
            long leaseStartTime = cmd.leaseStartTime();
            if (storageLeaseInfo == null || leaseStartTime != storageLeaseInfo.leaseStartTime()) {
                UpdateCommandResult updateCommandResult = new UpdateCommandResult(false, Long.valueOf(storageLeaseInfo == null ? 0L : storageLeaseInfo.leaseStartTime()), this.isPrimaryInGroupTopology(storageLeaseInfo), 0L);
                return new CommandResult((Serializable)updateCommandResult, false);
            }
        }
        UUID txId = cmd.txId();
        if (this.shouldUpdateStorage(cmd.full(), storageLeaseInfo)) {
            this.storageUpdateHandler.handleUpdateAll(txId, cmd.rowsToUpdate(), cmd.commitPartitionId().asReplicationGroupId(), !cmd.full(), () -> this.storage.lastApplied(commandIndex, commandTerm), (HybridTimestamp)(cmd.full() ? safeTimestamp : null), TableUtils.indexIdsAtRwTxBeginTs(this.catalogService, txId, this.storage.tableId()), cmd instanceof ArchiveAllCommand);
        } else {
            this.advanceLastAppliedIndexConsistently(commandIndex, commandTerm);
        }
        this.replicaTouch(txId, cmd.txCoordinatorId(), (HybridTimestamp)(cmd.full() ? safeTimestamp : null), cmd.full());
        return new CommandResult((Serializable)new UpdateCommandResult(true, this.isPrimaryInGroupTopology(storageLeaseInfo), safeTimestamp.longValue()), true);
    }

    private CommandResult handleWriteIntentSwitchCommand(WriteIntentSwitchCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        UUID txId = cmd.txId();
        this.storageUpdateHandler.switchWriteIntents(txId, cmd.commit(), cmd.commitTimestamp(), () -> this.storage.lastApplied(commandIndex, commandTerm), TableUtils.indexIdsAtRwTxBeginTsOrNull(this.catalogService, txId, this.storage.tableId()));
        return CommandResult.EMPTY_APPLIED_RESULT;
    }

    private CommandResult handleSafeTimeSyncCommand(SafeTimeSyncCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        this.advanceLastAppliedIndexConsistently(commandIndex, commandTerm);
        return CommandResult.EMPTY_APPLIED_RESULT;
    }

    private void advanceLastAppliedIndexConsistently(long commandIndex, long commandTerm) {
        this.storage.runConsistently(locker -> {
            this.storage.lastApplied(commandIndex, commandTerm);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationCommitted(RaftGroupConfiguration config, long lastAppliedIndex, long lastAppliedTerm) {
        if (config.index() <= this.storage.lastAppliedIndex()) {
            return;
        }
        this.setCurrentGroupTopology(config);
        this.storage.acquirePartitionSnapshotsReadLock();
        try {
            this.storage.runConsistently(locker -> {
                this.storage.committedGroupConfiguration(config);
                this.storage.lastApplied(lastAppliedIndex, lastAppliedTerm);
                return null;
            });
        }
        finally {
            this.storage.releasePartitionSnapshotsReadLock();
        }
    }

    private void setCurrentGroupTopology(RaftGroupConfiguration config) {
        this.currentGroupTopology.clear();
        this.currentGroupTopology.addAll(config.peers());
        this.currentGroupTopology.addAll(config.learners());
    }

    public void onSnapshotSave(Path path, Consumer<Throwable> doneClo) {
        throw new UnsupportedOperationException("!!! It's not expected that PartitionListener onSnapshotSave will be called.");
    }

    public boolean onSnapshotLoad(Path path) {
        return true;
    }

    public void onShutdown() {
        this.storage.close();
    }

    public long lastAppliedIndex() {
        return this.storage.lastAppliedIndex();
    }

    public long lastAppliedTerm() {
        return this.storage.lastAppliedTerm();
    }

    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) {
        if (lastAppliedIndex <= this.storage.lastAppliedIndex()) {
            return;
        }
        this.storage.runConsistently(locker -> {
            this.storage.lastApplied(lastAppliedIndex, lastAppliedTerm);
            return null;
        });
    }

    public CompletableFuture<Void> flushStorage() {
        return this.storage.flush();
    }

    @TestOnly
    public MvPartitionStorage getMvStorage() {
        return this.storage.getStorage();
    }

    PartitionDataStorage getStorage() {
        return this.storage;
    }

    @TestOnly
    public PendingComparableValuesTracker<HybridTimestamp, Void> getSafeTimeTracker() {
        return this.safeTimeTracker;
    }

    private CommandResult handlePrimaryReplicaChangeCommand(PrimaryReplicaChangeCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        this.storage.runConsistently(locker -> {
            LeaseInfo leaseInfo = new LeaseInfo(cmd.leaseStartTime(), cmd.primaryReplicaNodeId(), cmd.primaryReplicaNodeName());
            this.storage.updateLease(leaseInfo);
            this.storage.lastApplied(commandIndex, commandTerm);
            return null;
        });
        return CommandResult.EMPTY_APPLIED_RESULT;
    }

    private static <T extends Comparable<T>> void updateTrackerIgnoringTrackerClosedException(PendingComparableValuesTracker<T, Void> tracker, T newValue) {
        try {
            tracker.update(newValue, null);
        }
        catch (TrackerClosedException trackerClosedException) {
            // empty catch block
        }
    }

    private void replicaTouch(UUID txId, UUID txCoordinatorId, HybridTimestamp commitTimestamp, boolean full) {
        this.txManager.updateTxMeta(txId, old -> TxStateMeta.builder((TxStateMeta)old, (TxState)(full ? TxState.COMMITTED : TxState.PENDING)).txCoordinatorId(txCoordinatorId).commitTimestamp((HybridTimestamp)(full ? commitTimestamp : null)).build());
    }

    private boolean isPrimaryInGroupTopology(@Nullable LeaseInfo storageLeaseInfo) {
        return storageLeaseInfo == null || this.currentGroupTopology.contains(storageLeaseInfo.primaryReplicaNodeName());
    }
}

