/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.expiration.metrics;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.metrics.AbstractMetric;
import org.apache.ignite.internal.metrics.AtomicLongMetric;
import org.apache.ignite.internal.metrics.CompositeMetric;
import org.apache.ignite.internal.metrics.Metric;
import org.jetbrains.annotations.Nullable;

public class ExpirationTableMetric
extends AbstractMetric
implements CompositeMetric {
    static final int MAX_PRINTED_PARTITIONS = 5;
    private final Map<Integer, AtomicLongMetric> deletedExpiredRowsPerPartition = new ConcurrentHashMap<Integer, AtomicLongMetric>();

    ExpirationTableMetric(String name, @Nullable String desc) {
        super(name, desc);
    }

    void add(int partitionId, long delta) {
        this.deletedExpiredRowsPerPartition.computeIfAbsent(partitionId, k -> new AtomicLongMetric(String.valueOf(partitionId), "Number of deleted expired rows in partition " + partitionId)).add(delta);
    }

    void remove(int partitionId) {
        this.deletedExpiredRowsPerPartition.remove(partitionId);
    }

    boolean isEmpty() {
        return this.deletedExpiredRowsPerPartition.isEmpty();
    }

    public List<Metric> asScalarMetrics() {
        return List.copyOf(this.deletedExpiredRowsPerPartition.values());
    }

    @Nullable
    public String getValueAsString() {
        StringBuilder sb = new StringBuilder("[");
        int cnt = 0;
        for (Map.Entry<Integer, AtomicLongMetric> entry : this.deletedExpiredRowsPerPartition.entrySet()) {
            if (cnt < 5) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue().value()).append(", ");
                ++cnt;
                continue;
            }
            sb.append("...").append(", ");
            break;
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }
}

