/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.expiration;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.row.Row;

class ScannedRowsCollector
implements Flow.Subscriber<BinaryRow> {
    private final int batchSize;
    private final List<BinaryRowEx> scannedRows;
    private final SchemaDescriptor schemaDescriptor;
    private final CompletableFuture<List<BinaryRowEx>> scannedRowsFuture = new CompletableFuture();

    ScannedRowsCollector(int batchSize, SchemaDescriptor schemaDescriptor) {
        this.batchSize = batchSize;
        this.schemaDescriptor = schemaDescriptor;
        this.scannedRows = new ArrayList<BinaryRowEx>(batchSize);
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        subscription.request(this.batchSize);
    }

    @Override
    public void onNext(BinaryRow item) {
        this.scannedRows.add((BinaryRowEx)Row.wrapBinaryRow((SchemaDescriptor)this.schemaDescriptor, (BinaryRow)item));
    }

    @Override
    public void onError(Throwable throwable) {
        this.scannedRowsFuture.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        this.scannedRowsFuture.complete(this.scannedRows);
    }

    public CompletableFuture<List<BinaryRowEx>> result() {
        return this.scannedRowsFuture;
    }
}

