/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.cache.manager.IgniteCaches;
import org.apache.ignite.internal.table.distributed.PublicApiThreadingCache;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.table.QualifiedName;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingIgniteCaches
implements IgniteCaches,
Wrapper {
    private final IgniteCaches caches;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingIgniteCaches(IgniteCaches caches, Executor asyncContinuationExecutor) {
        assert (!(caches instanceof Wrapper)) : "Wrapping other wrappers is not supported";
        this.caches = caches;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public List<Cache> caches() {
        return this.applyAntiHijackProtection(this.caches.caches());
    }

    public CompletableFuture<List<Cache>> cachesAsync() {
        return this.preventThreadHijack(this.caches.cachesAsync()).thenApply(this::applyAntiHijackProtection);
    }

    @Nullable
    public Cache cache(QualifiedName name) {
        return this.applyAntiHijackProtection(this.caches.cache(name));
    }

    public CompletableFuture<Cache> cacheAsync(QualifiedName name) {
        return this.preventThreadHijack(this.caches.cacheAsync(name)).thenApply(this::applyAntiHijackProtection);
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.caches);
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, (Executor)this.asyncContinuationExecutor);
    }

    private List<Cache> applyAntiHijackProtection(List<Cache> cachesToWrap) {
        return cachesToWrap.stream().map(this::applyAntiHijackProtection).collect(Collectors.toList());
    }

    @Nullable
    private Cache applyAntiHijackProtection(@Nullable Cache cache) {
        if (cache == null) {
            return null;
        }
        return new PublicApiThreadingCache(cache, this.asyncContinuationExecutor);
    }
}

