/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.cache.CacheStoreFactory;
import org.apache.ignite.internal.table.PublicApiThreadingKeyValueView;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingCache
implements Cache,
Wrapper {
    private final Cache cache;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingCache(Cache cache, Executor asyncContinuationExecutor) {
        this.cache = cache;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public String name() {
        return this.cache.name();
    }

    public QualifiedName qualifiedName() {
        return this.cache.qualifiedName();
    }

    public <K, V> KeyValueView<K, V> keyValueView(CacheStoreFactory fac, Mapper<K> keyMapper, Mapper<V> valMapper) {
        return new PublicApiThreadingKeyValueView(this.cache.keyValueView(fac, keyMapper, valMapper), this.asyncContinuationExecutor);
    }

    public KeyValueView<Tuple, Tuple> keyValueView(CacheStoreFactory fac) {
        return new PublicApiThreadingKeyValueView<Tuple, Tuple>(this.cache.keyValueView(fac), this.asyncContinuationExecutor);
    }

    public <K, V> CompletableFuture<Void> loadAsync(CacheStoreFactory fac, Mapper<K> keyMapper, Mapper<V> valMapper, @Nullable BiPredicate<K, V> filter, Object ... args) {
        CompletableFuture fut = PublicApiThreading.execUserAsyncOperation(() -> this.cache.loadAsync(fac, keyMapper, valMapper, filter, args));
        return PublicApiThreading.preventThreadHijack((CompletableFuture)fut, (Executor)this.asyncContinuationExecutor);
    }

    public CompletableFuture<Void> loadAsync(CacheStoreFactory fac, @Nullable BiPredicate<Tuple, Tuple> filter, Object ... args) {
        CompletableFuture fut = PublicApiThreading.execUserAsyncOperation(() -> this.cache.loadAsync(fac, filter, args));
        return PublicApiThreading.preventThreadHijack((CompletableFuture)fut, (Executor)this.asyncContinuationExecutor);
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.cache);
    }
}

