/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.policy;

import org.apache.ignite.internal.table.policy.RlsChecker;
import org.jetbrains.annotations.Nullable;

abstract class RlsCheckerChain
extends RlsChecker {
    private final long since;
    @Nullable
    private volatile RlsCheckerChain prev;

    RlsCheckerChain(long since, @Nullable RlsCheckerChain prev) {
        assert (prev == null || since >= prev.since);
        this.since = since;
        this.prev = prev;
    }

    @Nullable
    RlsChecker resolve(long timestamp) {
        return this.resolveInternal(timestamp);
    }

    void trim(long minimalRequiredTime) {
        RlsCheckerChain current = this.resolveInternal(minimalRequiredTime);
        if (current != null) {
            current.prev = null;
        }
    }

    @Nullable
    private RlsCheckerChain resolveInternal(long timestamp) {
        RlsCheckerChain current = this;
        while (current != null && timestamp < current.since) {
            current = current.prev;
        }
        return current;
    }
}

