/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.message;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.table.message.PartitionModificationInfoMessage;
import org.apache.ignite.internal.table.message.PartitionModificationInfoMessageImpl;
import org.apache.ignite.internal.table.message.TableMessagesTypeInfos;

class PartitionModificationInfoMessageSerializer
implements MessageSerializer<PartitionModificationInfoMessage> {
    public static final PartitionModificationInfoMessageSerializer INSTANCE = new PartitionModificationInfoMessageSerializer();

    private PartitionModificationInfoMessageSerializer() {
    }

    public boolean writeMessage(PartitionModificationInfoMessage msg, MessageWriter writer) throws MessageMappingException {
        PartitionModificationInfoMessageImpl message = (PartitionModificationInfoMessageImpl)msg;
        writer.setMessageTypeInfo(TableMessagesTypeInfos.partitionModificationInfoMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("estimatedSize", message.estimatedSize());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("lastModificationCounter", message.lastModificationCounter());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeInt("partId", message.partId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

