/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.storage;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.partition.replicator.raft.PartitionSnapshotInfo;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionMvStorageAccess;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionTxStateAccess;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.secondarystoragebridge.UpdatesStorage;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class SecondaryStoragePartitionAccess
implements PartitionMvStorageAccess,
PartitionTxStateAccess {
    private final PartitionKey partitionKey;
    private final int tableId;
    private final UpdatesStorage updatesStorage;
    private final RaftGroupConfigurationConverter raftGroupConfigurationConverter = new RaftGroupConfigurationConverter();

    public SecondaryStoragePartitionAccess(PartitionKey partitionKey, int tableId, UpdatesStorage updatesStorage) {
        this.partitionKey = partitionKey;
        this.tableId = tableId;
        this.updatesStorage = updatesStorage;
    }

    public int tableId() {
        return this.tableId;
    }

    public int partitionId() {
        return this.partitionKey.partitionId();
    }

    public long lastAppliedIndex() {
        return this.updatesStorage.lastAppliedIndex();
    }

    public long lastAppliedTerm() {
        return this.updatesStorage.lastAppliedTerm();
    }

    @Nullable
    public RaftGroupConfiguration committedGroupConfiguration() {
        byte[] configurationBytes = this.updatesStorage.configuration();
        return configurationBytes == null ? null : this.raftGroupConfigurationConverter.fromBytes(configurationBytes);
    }

    @Nullable
    public LeaseInfo leaseInfo() {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    public CompletableFuture<Void> startRebalance() {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    public CompletableFuture<Void> abortRebalance() {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    public CompletableFuture<Void> finishRebalance(MvPartitionMeta partitionMeta) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    public void addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableId, int commitPartitionId, int catalogVersion, boolean isArchivation) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    public void addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp, int catalogVersion) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    public void addTxMeta(UUID txId, TxMeta txMeta) {
        throw new UnsupportedOperationException("TX state storage is missing.");
    }

    public Cursor<IgniteBiTuple<UUID, TxMeta>> getAllTxMeta() {
        throw new UnsupportedOperationException("Outgoing snapshots are not supported.");
    }

    @Nullable
    public RowId closestRowId(RowId lowerBound) {
        throw new UnsupportedOperationException("Outgoing snapshots are not supported.");
    }

    public List<ReadResult> getAllRowVersions(RowId rowId) throws StorageException {
        throw new UnsupportedOperationException("Outgoing snapshots are not supported.");
    }

    @Nullable
    public RowId getNextRowIdToBuildIndex(int indexId) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    public void setNextRowIdToBuildIndex(Map<Integer, RowId> nextRowIdToBuildByIndexId) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    public void updateLowWatermark(HybridTimestamp newLowWatermark) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Nullable
    public PartitionSnapshotInfo snapshotInfo() {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }
}

