/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.gc;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.table.distributed.gc.IntHolder;
import org.apache.ignite.internal.table.distributed.index.IndexUpdateHandler;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;

public class GcUpdateHandler {
    private final PartitionDataStorage storage;
    private final IndexUpdateHandler indexUpdateHandler;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker;

    public GcUpdateHandler(PartitionDataStorage storage, PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker, IndexUpdateHandler indexUpdateHandler) {
        this.storage = storage;
        this.indexUpdateHandler = indexUpdateHandler;
        this.safeTimeTracker = safeTimeTracker;
    }

    public PendingComparableValuesTracker<HybridTimestamp, Void> getSafeTimeTracker() {
        return this.safeTimeTracker;
    }

    public boolean vacuumBatch(HybridTimestamp lowWatermark, int count, boolean strict) {
        if (count <= 0) {
            return true;
        }
        this.storage.runConsistently(locker -> {
            this.storage.trimUpdateLog(lowWatermark, count);
            return null;
        });
        IntHolder countHolder = new IntHolder(count);
        block6: while (countHolder.get() > 0) {
            VacuumResult vacuumResult = this.internalVacuumBatch(lowWatermark, countHolder);
            switch (vacuumResult) {
                case NO_GARBAGE_LEFT: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
                case FAILED_ACQUIRE_LOCK: {
                    if (strict) continue block6;
                    return true;
                }
                case SHOULD_RELEASE: {
                    return true;
                }
            }
            throw new IllegalStateException(vacuumResult.toString());
        }
        return true;
    }

    private VacuumResult internalVacuumBatch(HybridTimestamp lowWatermark, IntHolder countHolder) {
        return (VacuumResult)((Object)this.storage.runConsistently(locker -> {
            int count = countHolder.get();
            for (int i = 0; i < count; ++i) {
                if (locker.shouldRelease()) {
                    return VacuumResult.SHOULD_RELEASE;
                }
                VacuumResult vacuumResult = this.internalVacuum(lowWatermark, locker, i > 0);
                if (vacuumResult != VacuumResult.SUCCESS) {
                    return vacuumResult;
                }
                countHolder.getAndDecrement();
            }
            return VacuumResult.SUCCESS;
        }));
    }

    private VacuumResult internalVacuum(HybridTimestamp lowWatermark, MvPartitionStorage.Locker locker, boolean useTryLock) {
        RowId rowId;
        GcEntry gcEntry;
        BinaryRow binaryRow;
        do {
            if (locker.shouldRelease()) {
                return VacuumResult.SHOULD_RELEASE;
            }
            gcEntry = this.storage.peek(lowWatermark);
            if (gcEntry == null) {
                return VacuumResult.NO_GARBAGE_LEFT;
            }
            rowId = gcEntry.getRowId();
            if (useTryLock) {
                if (locker.tryLock(rowId)) continue;
                return VacuumResult.FAILED_ACQUIRE_LOCK;
            }
            locker.lock(rowId);
        } while ((binaryRow = this.storage.vacuum(gcEntry)) == null);
        try (Cursor cursor = this.storage.scanVersions(rowId);){
            this.indexUpdateHandler.tryRemoveFromIndexes(binaryRow, rowId, (Cursor<ReadResult>)cursor, null);
        }
        return VacuumResult.SUCCESS;
    }

    private static enum VacuumResult {
        SUCCESS,
        NO_GARBAGE_LEFT,
        FAILED_ACQUIRE_LOCK,
        SHOULD_RELEASE;

    }
}

