/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import java.util.Collection;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.table.distributed.replicator.TxRwOperationCounter;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

public class IndexBuilderTxRwOperationTracker
implements ManuallyCloseable {
    private final AtomicInteger minAllowedCatalogVersionForStartOperation = new AtomicInteger(-1);
    private final NavigableMap<Integer, CompletableFuture<Void>> minAllowedVersionRaiseFutures = new ConcurrentSkipListMap<Integer, CompletableFuture<Void>>();
    private final NavigableMap<Integer, TxRwOperationCounter> operationCounterByCatalogVersion = new ConcurrentSkipListMap<Integer, TxRwOperationCounter>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();

    public void close() {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.closeFuture.completeExceptionally(new NodeStoppingException());
    }

    void updateMinAllowedCatalogVersionForStartOperation(int catalogVersion) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            this.minAllowedCatalogVersionForStartOperation.updateAndGet(previousCatalogVersion -> Math.max(catalogVersion, previousCatalogVersion));
            Collection futures = this.minAllowedVersionRaiseFutures.headMap(catalogVersion, true).values();
            futures.forEach(future -> future.complete(null));
            futures.clear();
        });
    }

    public CompletableFuture<Void> awaitCompleteTxRwOperations(int catalogVersion) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            CompletableFuture waitForMinAllowedReachingVersion = this.minAllowedVersionRaiseFutures.computeIfAbsent(catalogVersion, i -> new CompletableFuture());
            if (catalogVersion <= this.minAllowedCatalogVersionForStartOperation.get()) {
                this.minAllowedVersionRaiseFutures.remove(catalogVersion);
                waitForMinAllowedReachingVersion.complete(null);
            }
            waitForMinAllowedReachingVersion = this.orCloseFuture(waitForMinAllowedReachingVersion);
            return waitForMinAllowedReachingVersion.thenCompose(unused -> {
                CompletableFuture[] futures = (CompletableFuture[])this.operationCounterByCatalogVersion.headMap(catalogVersion, false).values().stream().map(TxRwOperationCounter::operationsFuture).toArray(CompletableFuture[]::new);
                return this.orCloseFuture(CompletableFuture.allOf(futures));
            });
        });
    }

    boolean incrementOperationCount(int catalogVersion) {
        return (Boolean)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            this.operationCounterByCatalogVersion.compute(catalogVersion, (i, txRwOperationCounter) -> {
                if (txRwOperationCounter == null) {
                    return TxRwOperationCounter.withCountOne();
                }
                return txRwOperationCounter.incrementOperationCount();
            });
            if (catalogVersion < this.minAllowedCatalogVersionForStartOperation.get()) {
                this.decrementOperationCount(catalogVersion);
                return false;
            }
            return true;
        });
    }

    void decrementOperationCount(int catalogVersion) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            TxRwOperationCounter[] localHolder = new TxRwOperationCounter[1];
            this.operationCounterByCatalogVersion.compute(catalogVersion, (i, txRwOperationCounter) -> {
                assert (txRwOperationCounter != null) : catalogVersion;
                localHolder[0] = null;
                if ((txRwOperationCounter = txRwOperationCounter.decrementOperationCount()).isOperationsOver()) {
                    localHolder[0] = txRwOperationCounter;
                    return null;
                }
                return txRwOperationCounter;
            });
            if (localHolder[0] != null) {
                localHolder[0].operationsFuture().complete(null);
            }
        });
    }

    private <T> CompletableFuture<T> orCloseFuture(CompletableFuture<T> future) {
        if (future.isDone()) {
            return future;
        }
        return CompletableFuture.anyOf(future, this.closeFuture).thenApply(o -> o);
    }
}

