/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.internal.table.distributed.PublicApiThreadingTable;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingIgniteTables
implements IgniteTables,
Wrapper {
    private final IgniteTables tables;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingIgniteTables(IgniteTables tables, Executor asyncContinuationExecutor) {
        assert (!(tables instanceof Wrapper)) : "Wrapping other wrappers is not supported";
        this.tables = tables;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public List<Table> tables() {
        return this.applyAntiHijackProtection(this.tables.tables());
    }

    public CompletableFuture<List<Table>> tablesAsync() {
        return this.preventThreadHijack(this.tables.tablesAsync()).thenApply(this::applyAntiHijackProtection);
    }

    public Table table(QualifiedName name) {
        return this.applyAntiHijackProtection(this.tables.table(name));
    }

    public CompletableFuture<Table> tableAsync(QualifiedName name) {
        return this.preventThreadHijack(this.tables.tableAsync(name)).thenApply(this::applyAntiHijackProtection);
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.tables);
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, (Executor)this.asyncContinuationExecutor);
    }

    private List<Table> applyAntiHijackProtection(List<Table> tablesToWrap) {
        return tablesToWrap.stream().map(this::applyAntiHijackProtection).collect(Collectors.toList());
    }

    @Nullable
    private Table applyAntiHijackProtection(@Nullable Table table) {
        if (table == null) {
            return null;
        }
        return new PublicApiThreadingTable(table, this.asyncContinuationExecutor);
    }
}

