/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.rebalance.AssignmentUtil;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Iif;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateEnum;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessage;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite.internal.partitiondistribution.PartitionDistributionUtils;
import org.apache.ignite.internal.partitiondistribution.PendingAssignmentsCalculator;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.GroupUpdateRequest;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateMessageByNode;
import org.apache.ignite.internal.table.distributed.disaster.exceptions.DisasterRecoveryException;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

abstract class GroupUpdateRequestHandler<T extends PartitionGroupId> {
    private static final IgniteLogger LOG = Loggers.forClass(GroupUpdateRequest.class);
    private final GroupUpdateRequest request;

    public static GroupUpdateRequestHandler<?> handler(GroupUpdateRequest request) {
        return request.colocationEnabled() ? new ZoneGroupUpdateRequestHandler(request) : new TableGroupUpdateRequestHandler(request);
    }

    GroupUpdateRequestHandler(GroupUpdateRequest request) {
        this.request = request;
    }

    public CompletableFuture<Void> handle(DisasterRecoveryManager disasterRecoveryManager, long msRevision, HybridTimestamp msTimestamp) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)disasterRecoveryManager.busyLock(), () -> {
            int catalogVersion = disasterRecoveryManager.catalogManager.activeCatalogVersion(msTimestamp.longValue());
            if (this.request.catalogVersion() != catalogVersion) {
                return CompletableFuture.failedFuture((Throwable)((Object)new DisasterRecoveryException(ErrorGroups.DisasterRecovery.CLUSTER_NOT_IDLE_ERR, "Cluster is not idle, concurrent DDL update detected.")));
            }
            Catalog catalog = disasterRecoveryManager.catalogManager.catalog(catalogVersion);
            int zoneId = this.request.zoneId();
            CatalogZoneDescriptor zoneDescriptor = catalog.zone(zoneId);
            HashSet<Integer> allZonePartitionsToReset = new HashSet<Integer>();
            this.request.partitionIds().values().forEach(allZonePartitionsToReset::addAll);
            CompletableFuture dataNodesFuture = disasterRecoveryManager.dzManager.dataNodes(msTimestamp, catalogVersion, zoneId);
            CompletableFuture<Map<T, LocalPartitionStateMessageByNode>> localStatesFuture = this.localStatesFuture(disasterRecoveryManager, Set.of(zoneDescriptor.name()), allZonePartitionsToReset, catalog);
            return ((CompletableFuture)dataNodesFuture.thenCombine(localStatesFuture, (dataNodes, localStatesMap) -> ((CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)disasterRecoveryManager.busyLock(), () -> {
                Set<String> nodeConsistentIds = disasterRecoveryManager.dzManager.logicalTopology(msRevision).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
                ArrayList<CompletableFuture<Void>> assignmentsUpdateFuts = new ArrayList<CompletableFuture<Void>>(this.request.partitionIds().size());
                for (Map.Entry<Integer, Set<Integer>> partitionEntry : this.request.partitionIds().entrySet()) {
                    int[] partitionIdsArray = AssignmentUtil.partitionIds(partitionEntry.getValue(), (int)zoneDescriptor.partitions());
                    assignmentsUpdateFuts.add(this.forceAssignmentsUpdate(partitionEntry.getKey(), zoneDescriptor, (Set<String>)dataNodes, nodeConsistentIds, msRevision, msTimestamp, disasterRecoveryManager.metaStorageManager, (Map<T, LocalPartitionStateMessageByNode>)localStatesMap, catalog.time(), partitionIdsArray, this.request.manualUpdate(), disasterRecoveryManager));
                }
                return CompletableFuture.allOf(assignmentsUpdateFuts.toArray(new CompletableFuture[0]));
            })).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    LOG.error("Failed to reset partition", throwable);
                }
            }))).thenCompose(Function.identity());
        });
    }

    private CompletableFuture<Void> forceAssignmentsUpdate(int replicationId, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, Set<String> aliveNodesConsistentIds, long revision, HybridTimestamp timestamp, MetaStorageManager metaStorageManager, Map<T, LocalPartitionStateMessageByNode> localStatesMap, long assignmentsTimestamp, int[] partitionIds, boolean manualUpdate, DisasterRecoveryManager disasterRecoveryManager) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)disasterRecoveryManager.busyLock(), () -> {
            CompletableFuture<Map<Integer, Assignments>> stableAssignments = this.stableAssignments(metaStorageManager, replicationId, partitionIds);
            return stableAssignments.thenCompose(assignments -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)disasterRecoveryManager.busyLock(), () -> {
                if (assignments.isEmpty()) {
                    return CompletableFutures.nullCompletedFuture();
                }
                return this.pendingAssignments(metaStorageManager, replicationId, partitionIds).thenCompose(pendingAssignments -> {
                    HashMap assignmentsMap = new HashMap(assignments);
                    assignmentsMap.putAll(pendingAssignments);
                    return this.updateAssignments(replicationId, zoneDescriptor, dataNodes, aliveNodesConsistentIds, revision, timestamp, metaStorageManager, localStatesMap, assignmentsTimestamp, partitionIds, (Map<Integer, Assignments>)assignments, AssignmentUtil.assignmentsAsList(assignmentsMap, (int)zoneDescriptor.partitions()), manualUpdate, disasterRecoveryManager);
                });
            }));
        });
    }

    private CompletableFuture<Void> updateAssignments(int replicationId, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, Set<String> aliveNodesConsistentIds, long revision, HybridTimestamp timestamp, MetaStorageManager metaStorageManager, Map<T, LocalPartitionStateMessageByNode> localStatesMap, long assignmentsTimestamp, int[] partitionIds, Map<Integer, Assignments> stableAssignments, List<Set<Assignment>> currentAllAssignments, boolean manualUpdate, DisasterRecoveryManager disasterRecoveryManager) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)disasterRecoveryManager.busyLock(), () -> {
            Set aliveDataNodes = CollectionUtils.intersect((Set)dataNodes, (Set)aliveNodesConsistentIds);
            CompletableFuture[] futures = new CompletableFuture[partitionIds.length];
            for (int i = 0; i < partitionIds.length; ++i) {
                Object replicaGrpId = this.replicationGroupId(replicationId, partitionIds[i]);
                LocalPartitionStateMessageByNode localStatesByNode = localStatesMap.containsKey(replicaGrpId) ? (LocalPartitionStateMessageByNode)localStatesMap.get(replicaGrpId) : new LocalPartitionStateMessageByNode(Collections.emptyMap());
                futures[i] = this.partitionUpdate(replicaGrpId, aliveDataNodes, aliveNodesConsistentIds, zoneDescriptor.partitions(), zoneDescriptor.replicas(), zoneDescriptor.consensusGroupSize(), revision, timestamp, metaStorageManager, ((Assignments)stableAssignments.get(replicaGrpId.partitionId())).nodes(), currentAllAssignments, localStatesByNode, assignmentsTimestamp, manualUpdate, disasterRecoveryManager).thenAccept(res -> DisasterRecoveryManager.LOG.info("Partition {} returned {} status on reset attempt", new Object[]{replicaGrpId, RebalanceUtil.UpdateStatus.valueOf((int)res)}));
            }
            return CompletableFuture.allOf(futures);
        });
    }

    private CompletableFuture<Integer> partitionUpdate(T partId, Collection<String> aliveDataNodes, Set<String> aliveNodesConsistentIds, int partitions, int replicas, int consensusGroupSize, long revision, HybridTimestamp timestamp, MetaStorageManager metaStorageMgr, Set<Assignment> currentAssignments, List<Set<Assignment>> currentAllAssignments, LocalPartitionStateMessageByNode localPartitionStateMessageByNode, long assignmentsTimestamp, boolean manualUpdate, DisasterRecoveryManager disasterRecoveryManager) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)disasterRecoveryManager.busyLock(), () -> {
            boolean isProposedPendingEqualsProposedPlanned;
            Set<Assignment> partAssignments = GroupUpdateRequestHandler.getAliveNodesWithData(aliveNodesConsistentIds, localPartitionStateMessageByNode);
            Set aliveStableNodes = CollectionUtils.intersect((Set)currentAssignments, partAssignments);
            if (aliveStableNodes.size() >= replicas / 2 + 1) {
                return CompletableFuture.completedFuture(RebalanceUtil.UpdateStatus.ASSIGNMENT_NOT_UPDATED.ordinal());
            }
            if (aliveStableNodes.isEmpty() && !manualUpdate) {
                return CompletableFuture.completedFuture(RebalanceUtil.UpdateStatus.ASSIGNMENT_NOT_UPDATED.ordinal());
            }
            if (manualUpdate) {
                GroupUpdateRequestHandler.enrichAssignments(partId, aliveDataNodes, partitions, replicas, consensusGroupSize, partAssignments, currentAllAssignments);
            }
            Assignment nextAssignment = GroupUpdateRequestHandler.nextAssignment(localPartitionStateMessageByNode, partAssignments);
            boolean bl = isProposedPendingEqualsProposedPlanned = partAssignments.size() == 1;
            assert (partAssignments.contains(nextAssignment)) : IgniteStringFormatter.format((String)"Recovery nodes set doesn't contain the reset node assignment [partAssignments={}, nextAssignment={}]", (Object[])new Object[]{partAssignments, nextAssignment});
            AssignmentsQueue assignmentsQueue = PendingAssignmentsCalculator.pendingAssignmentsCalculator().stable(Assignments.of((Set)currentAssignments, (long)assignmentsTimestamp)).target(Assignments.forced(Set.of(nextAssignment), (long)assignmentsTimestamp)).toQueue();
            return this.invoke(partId, revision, timestamp, metaStorageMgr, assignmentsTimestamp, assignmentsQueue, isProposedPendingEqualsProposedPlanned, partAssignments);
        });
    }

    private static Assignment nextAssignment(LocalPartitionStateMessageByNode localPartitionStateByNode, Set<Assignment> assignments) {
        Optional<Assignment> nodeWithMaxLogIndex = assignments.stream().filter(assignment -> localPartitionStateByNode.partitionState(assignment.consistentId()) != null).min(Comparator.comparingLong(node -> localPartitionStateByNode.partitionState(node.consistentId()).logIndex()).reversed().thenComparing(Assignment::consistentId)).or(() -> assignments.stream().min(Comparator.comparing(Assignment::consistentId)));
        return nodeWithMaxLogIndex.orElseThrow();
    }

    static Set<Assignment> getAliveNodesWithData(Set<String> aliveNodesConsistentIds, LocalPartitionStateMessageByNode localPartitionStateMessageByNode) {
        HashSet<Assignment> partAssignments = new HashSet<Assignment>();
        for (Map.Entry<String, LocalPartitionStateMessage> entry : localPartitionStateMessageByNode.entrySet()) {
            String nodeName = entry.getKey();
            LocalPartitionStateEnum state = entry.getValue().state();
            if (!aliveNodesConsistentIds.contains(nodeName) || state != LocalPartitionStateEnum.HEALTHY && state != LocalPartitionStateEnum.CATCHING_UP) continue;
            partAssignments.add(Assignment.forPeer((String)nodeName));
        }
        return partAssignments;
    }

    private static void enrichAssignments(PartitionGroupId partId, Collection<String> aliveDataNodes, int partitions, int replicas, int consensusGroupSize, Set<Assignment> partAssignments, List<Set<Assignment>> currentDistribution) {
        Set calcAssignments = PartitionDistributionUtils.calculateAssignmentForPartition(aliveDataNodes, currentDistribution, (int)partId.partitionId(), (int)partitions, (int)replicas, (int)consensusGroupSize);
        for (Assignment calcAssignment : calcAssignments) {
            if (partAssignments.size() == replicas) break;
            if (partAssignments.contains(Assignment.forPeer((String)calcAssignment.consistentId())) || partAssignments.contains(Assignment.forLearner((String)calcAssignment.consistentId()))) continue;
            partAssignments.add(calcAssignment);
        }
    }

    abstract CompletableFuture<Map<T, LocalPartitionStateMessageByNode>> localStatesFuture(DisasterRecoveryManager var1, Set<String> var2, Set<Integer> var3, Catalog var4);

    abstract CompletableFuture<Map<Integer, Assignments>> stableAssignments(MetaStorageManager var1, int var2, int[] var3);

    abstract CompletableFuture<Map<Integer, Assignments>> pendingAssignments(MetaStorageManager var1, int var2, int[] var3);

    abstract T replicationGroupId(int var1, int var2);

    abstract CompletableFuture<Integer> invoke(T var1, long var2, HybridTimestamp var4, MetaStorageManager var5, long var6, AssignmentsQueue var8, boolean var9, Set<Assignment> var10);

    static Iif executeInvoke(byte[] timestampBytes, byte[] pendingAssignmentsBytes, byte @Nullable [] plannedAssignmentsBytes, ByteArray pendingChangeTriggerKey, ByteArray partAssignmentsPendingKey, ByteArray partAssignmentsPlannedKey) {
        return Statements.iif((Condition)Conditions.notExists((ByteArray)pendingChangeTriggerKey).or((Condition)Conditions.value((ByteArray)pendingChangeTriggerKey).lt(timestampBytes)), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)pendingChangeTriggerKey, (byte[])timestampBytes), Operations.put((ByteArray)partAssignmentsPendingKey, (byte[])pendingAssignmentsBytes), plannedAssignmentsBytes == null ? Operations.remove((ByteArray)partAssignmentsPlannedKey) : Operations.put((ByteArray)partAssignmentsPlannedKey, (byte[])plannedAssignmentsBytes)}).yield(RebalanceUtil.UpdateStatus.PENDING_KEY_UPDATED.ordinal()), (Update)Operations.ops((Operation[])new Operation[0]).yield(RebalanceUtil.UpdateStatus.OUTDATED_UPDATE_RECEIVED.ordinal()));
    }

    private static class ZoneGroupUpdateRequestHandler
    extends GroupUpdateRequestHandler<ZonePartitionId> {
        ZoneGroupUpdateRequestHandler(GroupUpdateRequest request) {
            super(request);
        }

        @Override
        CompletableFuture<Map<ZonePartitionId, LocalPartitionStateMessageByNode>> localStatesFuture(DisasterRecoveryManager disasterRecoveryManager, Set<String> zoneNames, Set<Integer> partitionIds, Catalog catalog) {
            return disasterRecoveryManager.localPartitionStatesInternal(zoneNames, Collections.emptySet(), partitionIds, catalog, DisasterRecoveryManager.zoneState());
        }

        @Override
        CompletableFuture<Map<Integer, Assignments>> stableAssignments(MetaStorageManager metaStorageManager, int zoneId, int[] partitionIds) {
            return ZoneRebalanceUtil.zoneStableAssignments((MetaStorageManager)metaStorageManager, (int)zoneId, (int[])partitionIds);
        }

        @Override
        CompletableFuture<Map<Integer, Assignments>> pendingAssignments(MetaStorageManager metaStorageManager, int zoneId, int[] partitionIds) {
            return ZoneRebalanceUtil.zonePendingAssignments((MetaStorageManager)metaStorageManager, (int)zoneId, (int[])partitionIds);
        }

        @Override
        ZonePartitionId replicationGroupId(int id, int partitionId) {
            return new ZonePartitionId(id, partitionId);
        }

        @Override
        CompletableFuture<Integer> invoke(ZonePartitionId partId, long revision, HybridTimestamp timestamp, MetaStorageManager metaStorageMgr, long assignmentsTimestamp, AssignmentsQueue assignmentsQueue, boolean isProposedPendingEqualsProposedPlanned, Set<Assignment> partAssignments) {
            Iif invokeClosure = ZoneGroupUpdateRequestHandler.executeInvoke(ByteUtils.longToBytesKeepingOrder((long)timestamp.longValue()), assignmentsQueue.toBytes(), isProposedPendingEqualsProposedPlanned ? null : Assignments.toBytes(partAssignments, (long)assignmentsTimestamp, (boolean)true), ZoneRebalanceUtil.pendingChangeTriggerKey((ZonePartitionId)partId), ZoneRebalanceUtil.pendingPartAssignmentsQueueKey((ZonePartitionId)partId), ZoneRebalanceUtil.plannedPartAssignmentsKey((ZonePartitionId)partId));
            return metaStorageMgr.invoke(invokeClosure).thenApply(sr -> {
                switch (RebalanceUtil.UpdateStatus.valueOf((int)sr.getAsInt())) {
                    case PENDING_KEY_UPDATED: {
                        LOG.info("Force update metastore pending partitions key [key={}, partition={}, zone={}, newVal={}]", new Object[]{ZoneRebalanceUtil.pendingPartAssignmentsQueueKey((ZonePartitionId)partId).toString(), partId.partitionId(), partId.zoneId(), assignmentsQueue});
                        break;
                    }
                    case OUTDATED_UPDATE_RECEIVED: {
                        LOG.info("Received outdated force rebalance trigger event [revision={}, partition={}, zone={}]", new Object[]{revision, partId.partitionId(), partId.zoneId()});
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown return code for rebalance metastore multi-invoke");
                    }
                }
                return sr.getAsInt();
            });
        }
    }

    static class TableGroupUpdateRequestHandler
    extends GroupUpdateRequestHandler<TablePartitionId> {
        TableGroupUpdateRequestHandler(GroupUpdateRequest request) {
            super(request);
        }

        @Override
        CompletableFuture<Map<TablePartitionId, LocalPartitionStateMessageByNode>> localStatesFuture(DisasterRecoveryManager disasterRecoveryManager, Set<String> zoneNames, Set<Integer> partitionIds, Catalog catalog) {
            return disasterRecoveryManager.localPartitionStatesInternal(zoneNames, Collections.emptySet(), partitionIds, catalog, DisasterRecoveryManager.tableState());
        }

        @Override
        CompletableFuture<Map<Integer, Assignments>> stableAssignments(MetaStorageManager metaStorageManager, int tableId, int[] partitionIds) {
            return RebalanceUtil.tableStableAssignments((MetaStorageManager)metaStorageManager, (int)tableId, (int[])partitionIds);
        }

        @Override
        CompletableFuture<Map<Integer, Assignments>> pendingAssignments(MetaStorageManager metaStorageManager, int tableId, int[] partitionIds) {
            return RebalanceUtil.tablePendingAssignments((MetaStorageManager)metaStorageManager, (int)tableId, (int[])partitionIds);
        }

        @Override
        TablePartitionId replicationGroupId(int id, int partitionId) {
            return new TablePartitionId(id, partitionId);
        }

        @Override
        CompletableFuture<Integer> invoke(TablePartitionId partId, long revision, HybridTimestamp timestamp, MetaStorageManager metaStorageMgr, long assignmentsTimestamp, AssignmentsQueue assignmentsQueue, boolean isProposedPendingEqualsProposedPlanned, Set<Assignment> partAssignments) {
            Iif invokeClosure = TableGroupUpdateRequestHandler.executeInvoke(ByteUtils.longToBytesKeepingOrder((long)timestamp.longValue()), assignmentsQueue.toBytes(), isProposedPendingEqualsProposedPlanned ? null : Assignments.toBytes(partAssignments, (long)assignmentsTimestamp, (boolean)true), RebalanceUtil.pendingChangeTriggerKey((TablePartitionId)partId), RebalanceUtil.pendingPartAssignmentsQueueKey((TablePartitionId)partId), RebalanceUtil.plannedPartAssignmentsKey((TablePartitionId)partId));
            return metaStorageMgr.invoke(invokeClosure).thenApply(sr -> {
                switch (RebalanceUtil.UpdateStatus.valueOf((int)sr.getAsInt())) {
                    case PENDING_KEY_UPDATED: {
                        LOG.info("Force update metastore pending partitions key [key={}, partition={}, table={}, newVal={}]", new Object[]{RebalanceUtil.pendingPartAssignmentsQueueKey((TablePartitionId)partId).toString(), partId.partitionId(), partId.tableId(), assignmentsQueue});
                        break;
                    }
                    case OUTDATED_UPDATE_RECEIVED: {
                        LOG.info("Received outdated force rebalance trigger event [revision={}, partition={}, table={}]", new Object[]{revision, partId.partitionId(), partId.tableId()});
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown return code for rebalance metastore multi-invoke");
                    }
                }
                return sr.getAsInt();
            });
        }
    }
}

