/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.DropSecondaryZoneEventParameters;
import org.apache.ignite.internal.catalog.events.TableEventParameters;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.util.CompletableFutures;

class SecondaryStorageRebalanceTrigger {
    private final MetaStorageManager metaStorageManager;
    private final DistributionZoneManager distributionZoneManager;
    private final CatalogService catalogService;

    SecondaryStorageRebalanceTrigger(MetaStorageManager metaStorageManager, DistributionZoneManager distributionZoneManager, CatalogService catalogService) {
        this.metaStorageManager = metaStorageManager;
        this.distributionZoneManager = distributionZoneManager;
        this.catalogService = catalogService;
    }

    public void start() {
        this.catalogService.listen((Event)CatalogEvent.TABLE_ALTER, (EventListener)new SecondaryDataStorageModificationListener());
    }

    public void stop() {
    }

    private CompletableFuture<Void> triggerRebalanceFor(CatalogTableDescriptor table, CatalogZoneDescriptor zone, long causalityToken, HybridTimestamp timestamp, int catalogVersion, long assignmentsTimestamp) {
        return this.distributionZoneManager.dataNodes(timestamp, catalogVersion, zone.id()).thenCompose(dataNodes -> {
            if (dataNodes.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            Set aliveNodes = this.distributionZoneManager.logicalTopology(causalityToken).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
            return RebalanceUtil.triggerAllTablePartitionsRebalance((CatalogTableDescriptor)table, (CatalogZoneDescriptor)zone, (Set)dataNodes, (long)causalityToken, (HybridTimestamp)timestamp, (MetaStorageManager)this.metaStorageManager, (long)assignmentsTimestamp, aliveNodes);
        });
    }

    private class SecondaryDataStorageModificationListener
    implements EventListener<CatalogEventParameters> {
        private SecondaryDataStorageModificationListener() {
        }

        public CompletableFuture<Boolean> notify(CatalogEventParameters parameters) {
            return this.handleEvent(parameters).thenApply(ignored -> false);
        }

        private CompletableFuture<Void> handleEvent(CatalogEventParameters event) {
            if (event instanceof DropSecondaryZoneEventParameters) {
                return this.handle((TableEventParameters)event);
            }
            return CompletableFutures.nullCompletedFuture();
        }

        private CompletableFuture<Void> handle(TableEventParameters event) {
            Catalog catalog = SecondaryStorageRebalanceTrigger.this.catalogService.catalog(event.catalogVersion());
            assert (catalog != null) : "Did not find a catalog by version " + event.catalogVersion();
            CatalogTableDescriptor table = catalog.table(event.tableId());
            assert (table != null) : "Did not find a table by ID " + event.tableId() + " and catalog version " + event.catalogVersion();
            CatalogZoneDescriptor zone = catalog.zone(table.zoneId());
            assert (zone != null) : "Did not find a zone by ID " + table.zoneId() + " and catalog version " + event.catalogVersion();
            return SecondaryStorageRebalanceTrigger.this.triggerRebalanceFor(table, zone, event.causalityToken(), table.updateTimestamp(), event.catalogVersion(), catalog.time());
        }
    }
}

