/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.expiration;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.distributed.expiration.ExpiredRowsScannerImpl;
import org.apache.ignite.internal.table.distributed.expiration.LogUtils;
import org.apache.ignite.internal.table.distributed.expiration.PartitionCleanerHelper;
import org.apache.ignite.internal.table.distributed.expiration.TaskState;
import org.apache.ignite.internal.table.distributed.expiration.metrics.ExpirationMetricSource;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.utils.InternalTableProvider;
import org.apache.ignite.sql.ColumnType;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.TestOnly;

class PartitionCleanerTask
implements Runnable {
    private static final IgniteLogger LOG = Loggers.forClass(PartitionCleanerTask.class);
    private final int tableId;
    private final PartitionGroupId partitionKey;
    private final ClockService clockService;
    private final InternalTableProvider tableProvider;
    private final CatalogService catalogService;
    private final SchemaManager schemaManager;
    private final Semaphore semaphore;
    private final AtomicReference<TaskState> state = new AtomicReference<TaskState>(TaskState.SCHEDULED);
    private final CompletableFuture<Void> stopped = new CompletableFuture();
    private final PartitionCleanerHelper partitionCleanerHelper;

    PartitionCleanerTask(int tableId, PartitionGroupId partitionKey, ClockService clockService, HybridTimestampTracker observableTimestampTracker, InternalTableProvider tableProvider, CatalogService catalogService, SchemaManager schemaManager, TxManager txManager, InternalClusterNode localMember, int batchSize, Semaphore semaphore, ExpirationMetricSource metrics, LicenseFeatureChecker licenseFeatureChecker) {
        this.tableId = tableId;
        this.partitionKey = partitionKey;
        this.clockService = clockService;
        this.tableProvider = tableProvider;
        this.catalogService = catalogService;
        this.schemaManager = schemaManager;
        this.semaphore = semaphore;
        this.partitionCleanerHelper = new PartitionCleanerHelper(batchSize, tableId, partitionKey.partitionId(), txManager, observableTimestampTracker, localMember, licenseFeatureChecker, metrics, new ExpiredRowsScannerImpl());
    }

    @Override
    public void run() {
        if (this.state.compareAndSet(TaskState.SCHEDULED, TaskState.RUNNING)) {
            try {
                this.semaphore.acquire();
                this.run0().whenComplete((result, throwable) -> {
                    if (throwable != null && LogUtils.shouldBeLogged(throwable)) {
                        LOG.error("Unexpected error during table cleaning [tableId={}, partId={}]", throwable, new Object[]{this.tableId, this.partitionKey.partitionId()});
                    }
                    this.state.compareAndSet(TaskState.RUNNING, TaskState.SCHEDULED);
                    this.semaphore.release();
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                if (LogUtils.shouldBeLogged(e)) {
                    LOG.error("Failed to run table cleaning [tableId={}, partId={}]", (Throwable)e, new Object[]{this.tableId, this.partitionKey.partitionId()});
                }
                this.state.compareAndSet(TaskState.RUNNING, TaskState.SCHEDULED);
            }
        }
    }

    private CompletableFuture<Void> run0() {
        return this.clean().thenCompose(hasMore -> {
            if (hasMore.booleanValue() && !this.isCancelled()) {
                return this.run0();
            }
            if (this.isCancelled()) {
                this.stopped.complete(null);
                return this.stopped;
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private CompletableFuture<Boolean> clean() {
        HybridTimestamp hybridTimestamp = this.clockService.now();
        Catalog catalog = this.catalogService.activeCatalog(hybridTimestamp.longValue());
        CatalogTableDescriptor tableDescriptor = catalog.table(this.tableId);
        if (tableDescriptor == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        if (tableDescriptor.expireColumn() == null && tableDescriptor.archiveColumn() == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        InternalTable internalTable = this.tableProvider.table(tableDescriptor.id());
        if (internalTable == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        SchemaRegistry schemaRegistry = this.schemaManager.schemaRegistry(tableDescriptor.id());
        if (schemaRegistry == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        SchemaDescriptor schemaDescriptor = schemaRegistry.schema(tableDescriptor.latestSchemaVersion());
        Integer expireColIndexId = tableDescriptor.expireColumnIndexId();
        Integer archiveColIndexId = tableDescriptor.archiveColumnIndexId();
        if (expireColIndexId != null) {
            ColumnType expireColType = tableDescriptor.expireColumnType();
            if (expireColType == null) {
                return CompletableFutures.falseCompletedFuture();
            }
            CatalogIndexDescriptor expireIndex = catalog.index(expireColIndexId.intValue());
            if (expireIndex == null || expireIndex.status() != CatalogIndexStatus.AVAILABLE) {
                return CompletableFutures.falseCompletedFuture();
            }
            return this.partitionCleanerHelper.deleteExpiredRows(schemaDescriptor, internalTable, hybridTimestamp, expireColIndexId, expireColType);
        }
        if (archiveColIndexId != null) {
            ColumnType archiveColType = tableDescriptor.archiveColumnType();
            if (archiveColType == null) {
                return CompletableFutures.falseCompletedFuture();
            }
            CatalogIndexDescriptor archiveIndex = catalog.index(archiveColIndexId.intValue());
            if (archiveIndex == null || archiveIndex.status() != CatalogIndexStatus.AVAILABLE) {
                return CompletableFutures.falseCompletedFuture();
            }
            return this.partitionCleanerHelper.archiveExpiredRows(schemaDescriptor, internalTable, hybridTimestamp, archiveColIndexId, archiveColType);
        }
        return CompletableFutures.falseCompletedFuture();
    }

    private boolean isCancelled() {
        return Thread.currentThread().isInterrupted() || this.state.get() == TaskState.CANCELLED;
    }

    void cancel() {
        TaskState prevState = this.state.getAndSet(TaskState.CANCELLED);
        if (prevState != TaskState.RUNNING) {
            this.stopped.complete(null);
        }
    }

    CompletableFuture<Void> stopped() {
        return this.stopped;
    }

    @TestOnly
    TaskState state() {
        return this.state.get();
    }

    @TestOnly
    void state(TaskState state) {
        this.state.set(state);
    }
}

