/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.expiration;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.binarytuple.BinaryTuplePrefixBuilder;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.distributed.expiration.ExpiredRowsScanner;
import org.apache.ignite.internal.table.distributed.expiration.ScannedRowsCollector;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.sql.ColumnType;

class ExpiredRowsScannerImpl
implements ExpiredRowsScanner {
    ExpiredRowsScannerImpl() {
    }

    @Override
    public CompletableFuture<List<BinaryRowEx>> scan(InternalTransaction transaction, SchemaDescriptor schemaDescriptor, InternalTable internalTable, HybridTimestamp hybridTimestamp, int scannedColIndexId, ColumnType scannedColType, int batchSize, int partitionId, InternalClusterNode localMember) {
        ScannedRowsCollector handler = new ScannedRowsCollector(batchSize, schemaDescriptor);
        Flow.Publisher<BinaryRow> publisher = internalTable.scan(partitionId, transaction.id(), hybridTimestamp, localMember, scannedColIndexId, null, ExpiredRowsScannerImpl.timeNowAsBinaryTuplePrefix(scannedColType), 2, null, localMember.id());
        publisher.subscribe(handler);
        return handler.result();
    }

    private static BinaryTuplePrefix timeNowAsBinaryTuplePrefix(ColumnType type) {
        BinaryTuplePrefixBuilder builder = new BinaryTuplePrefixBuilder(1, 1, 1);
        if (type == ColumnType.DATETIME) {
            builder.appendDateTime(LocalDateTime.now());
        } else if (type == ColumnType.TIMESTAMP) {
            builder.appendTimestamp(Instant.now());
        }
        ByteBuffer upperBound = builder.build();
        return BinaryTuplePrefix.fromBinaryTuple((BinaryTuple)new BinaryTuple(1, upperBound));
    }
}

