/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.index;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.BinaryRowAndRowId;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageDestroyedException;
import org.apache.ignite.internal.table.distributed.TableIndexStoragesSupplier;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class IndexUpdateHandler {
    private final TableIndexStoragesSupplier indexes;

    public IndexUpdateHandler(TableIndexStoragesSupplier indexes) {
        this.indexes = indexes;
    }

    public void addToIndexes(@Nullable BinaryRow binaryRow, RowId rowId, @Nullable List<Integer> indexIds) {
        assert (indexIds == null || !indexIds.isEmpty()) : indexIds;
        if (binaryRow == null) {
            return;
        }
        for (TableSchemaAwareIndexStorage index : this.indexes(indexIds)) {
            IndexUpdateHandler.putToIndex(index, binaryRow, rowId);
        }
    }

    public void addToIndex(@Nullable BinaryRow binaryRow, RowId rowId, int indexId) {
        if (binaryRow == null) {
            return;
        }
        TableSchemaAwareIndexStorage indexStorage = this.indexStorageById().get(indexId);
        if (indexStorage != null) {
            IndexUpdateHandler.putToIndex(indexStorage, binaryRow, rowId);
        }
    }

    public void tryRemoveFromIndexes(BinaryRow rowToRemove, RowId rowId, Cursor<ReadResult> previousValues, @Nullable List<Integer> indexIds) {
        TableSchemaAwareIndexStorage[] indexes = this.indexesSnapshot(indexIds);
        ByteBuffer[] indexValues = new ByteBuffer[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            TableSchemaAwareIndexStorage index = indexes[i];
            indexValues[i] = index.indexRowResolver().extractColumns(rowToRemove).byteBuffer();
        }
        while (previousValues.hasNext()) {
            ReadResult previousVersion = (ReadResult)previousValues.next();
            BinaryRow previousRow = previousVersion.binaryRow();
            if (previousRow == null) continue;
            for (int i = 0; i < indexes.length; ++i) {
                BinaryTuple previousRowIndex;
                TableSchemaAwareIndexStorage index = indexes[i];
                if (index == null || !indexValues[i].equals((previousRowIndex = index.indexRowResolver().extractColumns(previousRow)).byteBuffer())) continue;
                indexes[i] = null;
            }
        }
        for (TableSchemaAwareIndexStorage index : indexes) {
            if (index == null) continue;
            IndexUpdateHandler.removeFromIndex(index, rowToRemove, rowId);
        }
    }

    public void buildIndex(int indexId, Stream<BinaryRowAndRowId> rowStream, @Nullable RowId nextRowIdToBuild) {
        TableSchemaAwareIndexStorage index = this.indexStorageById().get(indexId);
        if (index == null) {
            return;
        }
        rowStream.forEach(binaryRowAndRowId -> {
            BinaryRow binaryRow = binaryRowAndRowId.binaryRow();
            assert (binaryRow != null) : "indexId=" + indexId + ", rowId=" + binaryRowAndRowId.rowId();
            IndexUpdateHandler.putToIndex(index, binaryRow, binaryRowAndRowId.rowId());
        });
        IndexUpdateHandler.setNextRowIdToBuildToIndex(index, nextRowIdToBuild);
    }

    private Iterable<TableSchemaAwareIndexStorage> indexes(@Nullable List<Integer> indexIds) {
        Map<Integer, TableSchemaAwareIndexStorage> indexStorageById = this.indexStorageById();
        if (indexIds == null) {
            return indexStorageById.values();
        }
        ArrayList<TableSchemaAwareIndexStorage> res = new ArrayList<TableSchemaAwareIndexStorage>(indexIds.size());
        for (Integer indexId : indexIds) {
            TableSchemaAwareIndexStorage index = indexStorageById.get(indexId);
            if (index == null) continue;
            res.add(index);
        }
        return res;
    }

    private TableSchemaAwareIndexStorage[] indexesSnapshot(@Nullable List<Integer> indexIds) {
        Map<Integer, TableSchemaAwareIndexStorage> indexStorageById = this.indexStorageById();
        if (indexIds == null) {
            return (TableSchemaAwareIndexStorage[])indexStorageById.values().toArray(TableSchemaAwareIndexStorage[]::new);
        }
        ArrayList<TableSchemaAwareIndexStorage> res = new ArrayList<TableSchemaAwareIndexStorage>(indexIds.size());
        for (Integer indexId : indexIds) {
            TableSchemaAwareIndexStorage index = indexStorageById.get(indexId);
            if (index == null) continue;
            res.add(index);
        }
        return (TableSchemaAwareIndexStorage[])res.toArray(TableSchemaAwareIndexStorage[]::new);
    }

    @Nullable
    public RowId getNextRowIdToBuildIndex(int indexId) {
        TableSchemaAwareIndexStorage indexStorage = this.indexStorageById().get(indexId);
        if (indexStorage == null) {
            return null;
        }
        return IndexUpdateHandler.getNextRowIdToBuildFromIndex(indexStorage);
    }

    public void setNextRowIdToBuildIndex(int indexId, @Nullable RowId rowId) {
        TableSchemaAwareIndexStorage indexStorage = this.indexStorageById().get(indexId);
        if (indexStorage != null) {
            IndexUpdateHandler.setNextRowIdToBuildToIndex(indexStorage, rowId);
        }
    }

    private Map<Integer, TableSchemaAwareIndexStorage> indexStorageById() {
        Map<Integer, TableSchemaAwareIndexStorage> indexStorageById = this.indexes.get();
        assert (!indexStorageById.isEmpty());
        return indexStorageById;
    }

    private static void putToIndex(TableSchemaAwareIndexStorage indexStorage, BinaryRow binaryRow, RowId rowId) {
        try {
            indexStorage.put(binaryRow, rowId);
        }
        catch (StorageDestroyedException storageDestroyedException) {
            // empty catch block
        }
    }

    private static void removeFromIndex(TableSchemaAwareIndexStorage indexStorage, BinaryRow binaryRow, RowId rowId) {
        try {
            indexStorage.remove(binaryRow, rowId);
        }
        catch (StorageDestroyedException storageDestroyedException) {
            // empty catch block
        }
    }

    private static void setNextRowIdToBuildToIndex(TableSchemaAwareIndexStorage indexStorage, @Nullable RowId nextRowIdToBuild) {
        try {
            indexStorage.storage().setNextRowIdToBuild(nextRowIdToBuild);
        }
        catch (StorageDestroyedException storageDestroyedException) {
            // empty catch block
        }
    }

    @Nullable
    private static RowId getNextRowIdToBuildFromIndex(TableSchemaAwareIndexStorage indexStorage) {
        try {
            return indexStorage.storage().getNextRowIdToBuild();
        }
        catch (StorageDestroyedException ignore) {
            return null;
        }
    }
}

