/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.systemview;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.SchemaChangeIsForbiddenException;
import org.apache.ignite.internal.cluster.management.NodeAttributesProvider;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.systemview.api.NodeSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewColumn;
import org.apache.ignite.internal.systemview.api.SystemViewManager;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;
import org.apache.ignite.internal.systemview.utils.SystemViewUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.subscription.TransformingPublisher;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class SystemViewManagerImpl
implements SystemViewManager,
NodeAttributesProvider,
LogicalTopologyEventListener {
    public static final String NODE_ATTRIBUTES_KEY = "sql-system-views";
    public static final String NODE_ATTRIBUTES_LIST_SEPARATOR = ",";
    private static final IgniteLogger LOG = Loggers.forClass(SystemViewManagerImpl.class);
    private final String localNodeName;
    private final CatalogManager catalogManager;
    private final FailureProcessor failureProcessor;
    private final Map<String, String> nodeAttributes = new HashMap<String, String>();
    private final Map<String, SystemView<?>> views = new LinkedHashMap();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean startGuard = new AtomicBoolean();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final CompletableFuture<Void> viewsRegistrationFuture = new CompletableFuture();
    private volatile Map<String, ScannableView<?>> scannableViews = Map.of();
    private volatile Map<String, List<String>> owningNodesByViewName = Map.of();

    public SystemViewManagerImpl(String localNodeName, CatalogManager catalogManager, FailureProcessor failureProcessor) {
        this.localNodeName = localNodeName;
        this.catalogManager = catalogManager;
        this.failureProcessor = failureProcessor;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            if (!this.startGuard.compareAndSet(false, true)) {
                throw new IllegalStateException("System view manager cannot be started twice");
            }
            if (this.views.isEmpty()) {
                this.viewsRegistrationFuture.complete(null);
                return;
            }
            this.scannableViews = SystemViewManagerImpl.toScannableViews(this.localNodeName, this.views);
            List commands = this.views.values().stream().map(SystemViewUtils::toSystemViewCreateCommand).collect(Collectors.toList());
            ((CompletableFuture)this.catalogManager.catalogReadyFuture(1).thenCompose(x -> this.catalogManager.execute(commands))).whenComplete((r, t) -> {
                this.viewsRegistrationFuture.complete(null);
                if (t != null) {
                    if (ExceptionUtils.hasCause((Throwable)t, (Class[])new Class[]{NodeStoppingException.class})) {
                        return;
                    }
                    if (ExceptionUtils.hasCause((Throwable)t, (Class[])new Class[]{SchemaChangeIsForbiddenException.class})) {
                        LOG.warn("Unable to register system views because cluster upgrade is in progress.", t);
                        return;
                    }
                    this.failureProcessor.process(new FailureContext(t, "Failed to register system views."));
                }
            });
            this.nodeAttributes.put(NODE_ATTRIBUTES_KEY, String.join((CharSequence)NODE_ATTRIBUTES_LIST_SEPARATOR, this.views.keySet()));
        });
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.viewsRegistrationFuture.completeExceptionally((Throwable)new NodeStoppingException());
        this.busyLock.block();
        return CompletableFutures.nullCompletedFuture();
    }

    public List<String> owningNodes(String name) {
        return (List)IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.owningNodesByViewName.getOrDefault(name, List.of()));
    }

    public Flow.Publisher<InternalTuple> scanView(String name) {
        ScannableView<?> scannableView = this.scannableViews.get(name);
        if (scannableView == null) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, IgniteStringFormatter.format((String)"View with name '{}' not found on node '{}'", (Object[])new Object[]{name, this.localNodeName}));
        }
        return scannableView.scan();
    }

    public void register(SystemViewProvider viewProvider) {
        List views = viewProvider.systemViews();
        views.forEach(this::registerView);
    }

    public Map<String, String> nodeAttributes() {
        return this.nodeAttributes;
    }

    public void onNodeJoined(LogicalNode joinedNode, LogicalTopologySnapshot newTopology) {
        this.processNewTopology(newTopology);
    }

    public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
        this.processNewTopology(newTopology);
    }

    public void onTopologyLeap(LogicalTopologySnapshot newTopology) {
        this.processNewTopology(newTopology);
    }

    public CompletableFuture<Void> completeRegistration() {
        return this.viewsRegistrationFuture;
    }

    private void registerView(SystemView<?> view) {
        if (this.views.containsKey(view.name())) {
            throw new IllegalArgumentException(IgniteStringFormatter.format((String)"The view with name '{}' already registered", (Object[])new Object[]{view.name()}));
        }
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            if (this.startGuard.get()) {
                throw new IllegalStateException(IgniteStringFormatter.format((String)"Unable to register view '{}', manager already started", (Object[])new Object[]{view.name()}));
            }
            this.views.put(view.name(), view);
        });
    }

    private void processNewTopology(LogicalTopologySnapshot topology) {
        HashMap<String, List> owningNodesByViewName = new HashMap<String, List>();
        for (LogicalNode logicalNode : topology.nodes()) {
            String systemViewsNames = (String)logicalNode.systemAttributes().get(NODE_ATTRIBUTES_KEY);
            if (systemViewsNames == null) continue;
            Arrays.stream(systemViewsNames.split(NODE_ATTRIBUTES_LIST_SEPARATOR)).map(String::trim).forEach(viewName -> owningNodesByViewName.computeIfAbsent((String)viewName, key -> new ArrayList()).add(logicalNode.name()));
        }
        for (String viewName2 : owningNodesByViewName.keySet()) {
            owningNodesByViewName.compute(viewName2, (key, value) -> {
                assert (value != null);
                return List.copyOf(value);
            });
        }
        this.owningNodesByViewName = Map.copyOf(owningNodesByViewName);
    }

    private static Map<String, ScannableView<?>> toScannableViews(String localNodeName, Map<String, SystemView<?>> views) {
        HashMap scannableViews = new HashMap();
        NodeViewRowFactory nodeViewRowFactory = new NodeViewRowFactory(localNodeName);
        for (SystemView<?> view : views.values()) {
            ViewRowFactory rowFactory = view instanceof NodeSystemView ? nodeViewRowFactory : ClusterViewRowFactory.INSTANCE;
            scannableViews.put(view.name(), new ScannableView(rowFactory, view));
        }
        return Map.copyOf(scannableViews);
    }

    private static class ScannableView<T> {
        private final Flow.Publisher<InternalTuple> publisher;

        private ScannableView(ViewRowFactory rowFactory, SystemView<T> view) {
            BinaryTupleSchema schema = SystemViewUtils.tupleSchemaForView(view);
            this.publisher = new TransformingPublisher(view.dataProvider(), object -> rowFactory.create(schema, view, object));
        }

        Flow.Publisher<InternalTuple> scan() {
            return this.publisher;
        }
    }

    private static class NodeViewRowFactory
    extends ViewRowFactory {
        private final String nodeName;

        private NodeViewRowFactory(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        <ViewSourceT> InternalTuple create(BinaryTupleSchema schema, SystemView<ViewSourceT> view, ViewSourceT source) {
            return new NodeViewRow<ViewSourceT>(schema, this.nodeName, view, source);
        }
    }

    private static class ClusterViewRowFactory
    extends ViewRowFactory {
        private static final ViewRowFactory INSTANCE = new ClusterViewRowFactory();

        private ClusterViewRowFactory() {
        }

        @Override
        <ViewSourceT> InternalTuple create(BinaryTupleSchema schema, SystemView<ViewSourceT> view, ViewSourceT source) {
            return new ClusterViewRow<ViewSourceT>(schema, view, source);
        }
    }

    private static abstract class ViewRowFactory {
        private ViewRowFactory() {
        }

        abstract <ViewSourceT> InternalTuple create(BinaryTupleSchema var1, SystemView<ViewSourceT> var2, ViewSourceT var3);
    }

    private static abstract class AbstractViewRow
    implements InternalTuple {
        private final BinaryTupleSchema schema;

        private AbstractViewRow(BinaryTupleSchema schema) {
            this.schema = schema;
        }

        abstract <T> T value(int var1);

        public boolean hasNullValue(int columnIndex) {
            return this.value(columnIndex) == null;
        }

        public boolean booleanValue(int columnIndex) {
            return (Boolean)this.value(columnIndex);
        }

        public Boolean booleanValueBoxed(int columnIndex) {
            return (Boolean)this.value(columnIndex);
        }

        public byte byteValue(int columnIndex) {
            return (Byte)this.value(columnIndex);
        }

        public Byte byteValueBoxed(int columnIndex) {
            return (Byte)this.value(columnIndex);
        }

        public short shortValue(int columnIndex) {
            return (Short)this.value(columnIndex);
        }

        public Short shortValueBoxed(int columnIndex) {
            return (Short)this.value(columnIndex);
        }

        public int intValue(int columnIndex) {
            return (Integer)this.value(columnIndex);
        }

        public Integer intValueBoxed(int columnIndex) {
            return (Integer)this.value(columnIndex);
        }

        public long longValue(int columnIndex) {
            return (Long)this.value(columnIndex);
        }

        public Long longValueBoxed(int columnIndex) {
            return (Long)this.value(columnIndex);
        }

        public float floatValue(int columnIndex) {
            return ((Float)this.value(columnIndex)).floatValue();
        }

        public Float floatValueBoxed(int columnIndex) {
            return (Float)this.value(columnIndex);
        }

        public double doubleValue(int columnIndex) {
            return (Double)this.value(columnIndex);
        }

        public Double doubleValueBoxed(int columnIndex) {
            return (Double)this.value(columnIndex);
        }

        @Nullable
        public BigDecimal decimalValue(int columnIndex, int scale) {
            BigDecimal value = (BigDecimal)this.value(columnIndex);
            if (value == null) {
                return null;
            }
            return value.setScale(scale, RoundingMode.UNNECESSARY);
        }

        public String stringValue(int columnIndex) {
            return (String)this.value(columnIndex);
        }

        public byte[] bytesValue(int columnIndex) {
            return (byte[])this.value(columnIndex);
        }

        public UUID uuidValue(int columnIndex) {
            return (UUID)this.value(columnIndex);
        }

        public LocalDate dateValue(int columnIndex) {
            return (LocalDate)this.value(columnIndex);
        }

        public LocalTime timeValue(int columnIndex) {
            return (LocalTime)this.value(columnIndex);
        }

        public LocalDateTime dateTimeValue(int columnIndex) {
            return (LocalDateTime)this.value(columnIndex);
        }

        public Instant timestampValue(int columnIndex) {
            return (Instant)this.value(columnIndex);
        }

        public Period periodValue(int columnIndex) {
            return (Period)this.value(columnIndex);
        }

        public Duration durationValue(int columnIndex) {
            return (Duration)this.value(columnIndex);
        }

        public ByteBuffer byteBuffer() {
            BinaryTupleBuilder builder = new BinaryTupleBuilder(this.schema.elementCount());
            for (int i = 0; i < this.schema.elementCount(); ++i) {
                this.schema.appendValue(builder, i, this.value(i));
            }
            return builder.build();
        }
    }

    private static class ClusterViewRow<T>
    extends AbstractViewRow {
        private final SystemView<T> view;
        private final T source;

        private ClusterViewRow(BinaryTupleSchema schema, SystemView<T> view, T source) {
            super(schema);
            this.view = view;
            this.source = source;
        }

        public int elementCount() {
            return this.view.columns().size();
        }

        public int size() {
            return 128;
        }

        <ReturnT> ReturnT value(int columnIndex) {
            return (ReturnT)((SystemViewColumn)this.view.columns().get(columnIndex)).value().apply(this.source);
        }
    }

    private static class NodeViewRow<T>
    extends AbstractViewRow {
        private final String nodeName;
        private final SystemView<T> view;
        private final T source;

        private NodeViewRow(BinaryTupleSchema schema, String nodeName, SystemView<T> view, T source) {
            super(schema);
            this.nodeName = nodeName;
            this.view = view;
            this.source = source;
        }

        public int elementCount() {
            return this.view.columns().size() + 1;
        }

        public int size() {
            return 128;
        }

        <ReturnT> ReturnT value(int columnIndex) {
            return (ReturnT)(columnIndex == 0 ? this.nodeName : ((SystemViewColumn)this.view.columns().get(columnIndex - 1)).value().apply(this.source));
        }
    }
}

