/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageProfileView;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageProfile;
import org.apache.ignite.internal.storage.rocksdb.RocksDbTableStorage;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbProfileConfiguration;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbProfileView;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbStorageEngineConfiguration;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbStorageEngineExtensionConfiguration;
import org.apache.ignite.internal.storage.rocksdb.instance.SharedRocksDbInstance;
import org.apache.ignite.internal.storage.rocksdb.instance.SharedRocksDbInstanceCreator;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.license.LicenseFeature;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rocksdb.RocksDB;

public class RocksDbStorageEngine
implements StorageEngine {
    public static final String ENGINE_NAME = "rocksdb";
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbStorageEngine.class);
    private final RocksDbStorageEngineConfiguration engineConfig;
    private final StorageConfiguration storageConfiguration;
    private final Path storagePath;
    private final ExecutorService threadPool;
    private final ScheduledExecutorService scheduledPool;
    private final FailureProcessor failureProcessor;
    private final String nodeName;
    private final Map<String, RocksDbStorage> storageByProfileName = new ConcurrentHashMap<String, RocksDbStorage>();
    private final LogSyncer logSyncer;
    private final EncryptionManager encryptionManager;

    public RocksDbStorageEngine(String nodeName, StorageConfiguration storageConfiguration, Path storagePath, LogSyncer logSyncer, ScheduledExecutorService scheduledPool, EncryptionManager encryptionManager, FailureProcessor failureProcessor) {
        this.storageConfiguration = storageConfiguration;
        this.engineConfig = ((RocksDbStorageEngineExtensionConfiguration)storageConfiguration.engines()).rocksdb();
        this.storagePath = storagePath;
        this.logSyncer = logSyncer;
        this.scheduledPool = scheduledPool;
        this.encryptionManager = encryptionManager;
        this.failureProcessor = failureProcessor;
        this.nodeName = nodeName;
        this.threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"rocksdb-storage-engine-pool", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
    }

    public RocksDbStorageEngineConfiguration configuration() {
        return this.engineConfig;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public ScheduledExecutorService scheduledPool() {
        return this.scheduledPool;
    }

    public LogSyncer logSyncer() {
        return this.logSyncer;
    }

    public String name() {
        return ENGINE_NAME;
    }

    public void start() throws StorageException {
        for (StorageProfileView profile : (NamedListView)this.storageConfiguration.profiles().value()) {
            if (!(profile instanceof RocksDbProfileView)) continue;
            String profileName = profile.name();
            RocksDbProfileConfiguration storageProfileConfiguration = (RocksDbProfileConfiguration)this.storageConfiguration.profiles().get(profileName);
            assert (storageProfileConfiguration != null) : profileName;
            this.registerProfile(storageProfileConfiguration);
        }
    }

    private void registerProfile(RocksDbProfileConfiguration profileConfig) {
        String profileName = (String)profileConfig.name().value();
        RocksDbStorageProfile profile = new RocksDbStorageProfile(profileConfig);
        profile.start();
        SharedRocksDbInstance rocksDbInstance = this.newRocksDbInstance(profileName, profile);
        RocksDbStorage previousStorage = this.storageByProfileName.put(profileName, new RocksDbStorage(profile, rocksDbInstance));
        assert (previousStorage == null) : "Storage already exists for profile: " + profileName;
    }

    private SharedRocksDbInstance newRocksDbInstance(String profileName, RocksDbStorageProfile profile) {
        Path dbPath = this.storagePath.resolve("rocksdb-" + profileName);
        try {
            return new SharedRocksDbInstanceCreator(this.failureProcessor, this.nodeName).create(this, profile, dbPath, this.encryptionManager);
        }
        catch (Exception e) {
            throw new StorageException("Failed to create new RocksDB instance", (Throwable)e);
        }
    }

    public void stop() throws StorageException {
        try {
            IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{() -> IgniteUtils.closeAllManually(this.storageByProfileName.values()), () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS)});
        }
        catch (Exception e) {
            throw new StorageException("Error when stopping the rocksdb engine", (Throwable)e);
        }
    }

    public boolean isVolatile() {
        return false;
    }

    public RocksDbTableStorage createMvTable(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) throws StorageException {
        String profileName = tableDescriptor.getStorageProfile();
        RocksDbStorage storage = this.storageByProfileName.get(profileName);
        assert (storage != null) : String.format("RocksDB instance has not yet been created for [tableId=%d, profile=%s]", tableDescriptor.getId(), profileName);
        RocksDbTableStorage tableStorage = new RocksDbTableStorage(storage.rocksDbInstance, tableDescriptor, indexDescriptorSupplier);
        tableStorage.start();
        return tableStorage;
    }

    public void destroyMvTable(int tableId) {
        for (RocksDbStorage rocksDbStorage : this.storageByProfileName.values()) {
            rocksDbStorage.rocksDbInstance.destroyTable(tableId);
        }
    }

    public Set<Integer> tableIdsOnDisk() {
        return this.storageByProfileName.values().stream().flatMap(storage -> storage.rocksDbInstance.tableIdsOnDisk().stream()).collect(Collectors.toUnmodifiableSet());
    }

    public CompletableFuture<Void> flush() {
        CompletableFuture[] futures = (CompletableFuture[])this.storageByProfileName.values().stream().map(storage -> storage.rocksDbInstance.flush()).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    @Nullable
    public LicenseFeature licenseFeature() {
        return LicenseFeature.ROCKSDB;
    }

    public boolean hasConfiguredStorageProfiles() {
        return StorageUtils.hasConfiguredStorageProfiles((StorageConfiguration)this.storageConfiguration, RocksDbProfileView.class);
    }

    @TestOnly
    public CompletableFuture<Void> flushStorages() {
        CompletableFuture[] futures = (CompletableFuture[])this.storageByProfileName.values().stream().map(storage -> storage.rocksDbInstance.flush()).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    static {
        RocksDB.loadLibrary();
    }

    private static class RocksDbStorage
    implements ManuallyCloseable {
        final RocksDbStorageProfile profile;
        final SharedRocksDbInstance rocksDbInstance;

        RocksDbStorage(RocksDbStorageProfile profile, SharedRocksDbInstance rocksDbInstance) {
            this.profile = profile;
            this.rocksDbInstance = rocksDbInstance;
        }

        public void close() throws Exception {
            ManuallyCloseable[] manuallyCloseableArray = new ManuallyCloseable[2];
            manuallyCloseableArray[0] = this.rocksDbInstance::stop;
            manuallyCloseableArray[1] = this.profile::stop;
            IgniteUtils.closeAllManually((ManuallyCloseable[])manuallyCloseableArray);
        }
    }
}

