/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import com.google.auto.service.AutoService;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageEngine;
import org.apache.ignite.internal.vault.VaultManager;
import org.gridgain.internal.encryption.EncryptionManager;
import org.jetbrains.annotations.Nullable;

@AutoService(value={DataStorageModule.class})
public class RocksDbDataStorageModule
implements DataStorageModule {
    public String name() {
        return "rocksdb";
    }

    public StorageEngine createEngine(String igniteInstanceName, MetricManager metricManager, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, VaultManager vaultManager, EncryptionManager encryptionManager, LogSyncer logSyncer, HybridClock clock, ScheduledExecutorService commonScheduler) throws StorageException {
        StorageConfiguration storageConfig = ((StorageExtensionConfiguration)configRegistry.getConfiguration(StorageExtensionConfiguration.KEY)).storage();
        return new RocksDbStorageEngine(igniteInstanceName, storageConfig, storagePath, logSyncer, commonScheduler, encryptionManager, (FailureProcessor)failureManager);
    }
}

