/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.tombstones;

import java.util.NoSuchElementException;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.tombstones.Tombstone;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public abstract class TombstonesCursor
implements Cursor<Tombstone> {
    @Nullable
    protected final Long fromExcluding;
    @Nullable
    protected final Long toIncluding;
    @Nullable
    protected Tombstone next;
    @Nullable
    private RowId lastRowId;

    protected TombstonesCursor(@Nullable HybridTimestamp fromExcluding, @Nullable HybridTimestamp toIncluding) {
        this.fromExcluding = fromExcluding == null ? null : Long.valueOf(fromExcluding.longValue());
        this.toIncluding = toIncluding == null ? null : Long.valueOf(toIncluding.longValue());
    }

    public boolean hasNext() {
        this.advanceIfNeeded();
        return this.next != null;
    }

    public Tombstone next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Tombstone current = this.next;
        this.lastRowId = current.rowId();
        this.next = null;
        return current;
    }

    protected abstract void advanceIfNeeded();

    protected boolean shouldAdvance() {
        return this.next == null || this.equalsToLastRowId(this.next.rowId()) || this.outsideBounds(this.next.timestamp().longValue());
    }

    protected boolean equalsToLastRowId(RowId rowId) {
        return rowId.equals(this.lastRowId);
    }

    protected boolean outsideBounds(long timestamp) {
        return this.fromExcluding != null && timestamp <= this.fromExcluding || this.toIncluding != null && timestamp > this.toIncluding;
    }
}

