/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.continuousquery.RowUpdateInfo;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.AbortResult;
import org.apache.ignite.internal.storage.AddWriteCommittedResult;
import org.apache.ignite.internal.storage.AddWriteResult;
import org.apache.ignite.internal.storage.CommitResult;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.RowMeta;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.storage.tombstones.Tombstone;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.table.TableRowEventType;
import org.jetbrains.annotations.Nullable;

public interface MvPartitionStorage
extends ManuallyCloseable {
    public static final long REBALANCE_IN_PROGRESS = -1L;

    public <V> V runConsistently(WriteClosure<V> var1) throws StorageException;

    default public CompletableFuture<Void> flush() {
        return this.flush(true);
    }

    public CompletableFuture<Void> flush(boolean var1);

    public long lastAppliedIndex();

    public long lastAppliedTerm();

    public void lastApplied(long var1, long var3) throws StorageException;

    public byte @Nullable [] committedGroupConfiguration();

    public void committedGroupConfiguration(byte[] var1);

    public ReadResult read(RowId var1, HybridTimestamp var2) throws StorageException;

    default public AddWriteResult addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitZoneId, int commitPartitionId) throws StorageException {
        return this.addWrite(rowId, row, txId, commitZoneId, commitPartitionId, false);
    }

    public AddWriteResult addWrite(RowId var1, @Nullable BinaryRow var2, UUID var3, int var4, int var5, boolean var6) throws StorageException;

    public AbortResult abortWrite(RowId var1, UUID var2) throws StorageException;

    public CommitResult commitWrite(RowId var1, HybridTimestamp var2, UUID var3) throws StorageException;

    public void discard(RowId var1) throws StorageException;

    public AddWriteCommittedResult addWriteCommitted(RowId var1, @Nullable BinaryRow var2, HybridTimestamp var3) throws StorageException;

    public Cursor<ReadResult> scanVersions(RowId var1) throws StorageException;

    public PartitionTimestampCursor scan(HybridTimestamp var1) throws StorageException;

    public PartitionTimestampCursor scan(HybridTimestamp var1, HybridTimestamp var2) throws StorageException;

    public Cursor<Tombstone> scanSnapshotTombstones(@Nullable HybridTimestamp var1, @Nullable HybridTimestamp var2) throws StorageException;

    public boolean snapshotTombstonesPreservationSupported();

    public void clearSnapshotTombstones(HybridTimestamp var1);

    public Cursor<ReadResult> scanAllVersions(RowId var1, HybridTimestamp var2, HybridTimestamp var3) throws StorageException;

    public List<RowUpdateInfo<BinaryRow>> scanUpdateLog(HybridTimestamp var1, RowId var2, HybridTimestamp var3, int var4, EnumSet<TableRowEventType> var5, boolean var6) throws StorageException;

    public void trimUpdateLog(HybridTimestamp var1, int var2);

    @Nullable
    public RowId closestRowId(RowId var1) throws StorageException;

    @Nullable
    public RowId highestRowId() throws StorageException;

    public List<RowMeta> rowsStartingWith(RowId var1, RowId var2, int var3) throws StorageException;

    public List<GcEntry> peek(HybridTimestamp var1, int var2);

    @Nullable
    public BinaryRow vacuum(GcEntry var1);

    public void updateLease(LeaseInfo var1);

    @Nullable
    public LeaseInfo leaseInfo();

    public long estimatedSize();

    public Cursor<RowId> scanWriteIntents();

    public void close();

    public static interface Locker {
        public void lock(RowId var1);

        public boolean tryLock(RowId var1);

        public boolean shouldRelease();
    }

    @FunctionalInterface
    public static interface WriteClosure<V> {
        public V execute(Locker var1) throws StorageException;
    }
}

