/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class RowMeta {
    private final RowId rowId;
    @Nullable
    private final UUID transactionId;
    @Nullable
    private final Integer commitZoneId;
    private final int commitPartitionId;

    public static RowMeta withoutWriteIntent(RowId rowId) {
        return new RowMeta(rowId, null, null, -1);
    }

    public RowMeta(RowId rowId, @Nullable UUID transactionId, @Nullable Integer commitZoneId, int commitPartitionId) {
        this.rowId = rowId;
        this.transactionId = transactionId;
        this.commitZoneId = commitZoneId;
        this.commitPartitionId = commitPartitionId;
    }

    public RowId rowId() {
        return this.rowId;
    }

    @Nullable
    public UUID transactionId() {
        return this.transactionId;
    }

    public boolean isWriteIntent() {
        return this.transactionId != null;
    }

    @Nullable
    public Integer commitZoneId() {
        return this.commitZoneId;
    }

    public int commitPartitionId() {
        return this.commitPartitionId;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowMeta rowMeta = (RowMeta)o;
        return this.commitPartitionId == rowMeta.commitPartitionId && Objects.equals(this.rowId, rowMeta.rowId) && Objects.equals(this.transactionId, rowMeta.transactionId) && Objects.equals(this.commitZoneId, rowMeta.commitZoneId);
    }

    public int hashCode() {
        return Objects.hash(this.rowId, this.transactionId, this.commitZoneId, this.commitPartitionId);
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

