/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.util.LockByRowId;

public class LocalLocker
implements MvPartitionStorage.Locker {
    private final LockByRowId locks;
    private Object locked;

    public LocalLocker(LockByRowId locks) {
        this.locks = locks;
    }

    @Override
    public void lock(RowId rowId) {
        this.locks.lock(rowId);
        this.markAsLocked(rowId);
    }

    @Override
    public boolean tryLock(RowId rowId) {
        if (this.locks.tryLock(rowId)) {
            this.markAsLocked(rowId);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRelease() {
        return false;
    }

    public boolean isLocked(RowId rowId) {
        return Objects.equals(rowId, this.locked) || this.locked instanceof Set && ((Set)this.locked).contains(rowId);
    }

    public void unlockAll() {
        if (this.locked instanceof RowId) {
            this.locks.unlockAll((RowId)this.locked);
        } else if (this.locked != null) {
            for (RowId rowId : (Set)this.locked) {
                this.locks.unlockAll(rowId);
            }
        }
    }

    private void markAsLocked(RowId rowId) {
        if (this.locked == null) {
            this.locked = rowId;
        } else {
            if (this.locked instanceof RowId) {
                if (this.locked.equals(rowId)) {
                    return;
                }
                HashSet<Object> rowIds = new HashSet<Object>();
                rowIds.add(this.locked);
                this.locked = rowIds;
            }
            assert (this.locked instanceof Set);
            ((Set)this.locked).add(rowId);
        }
    }
}

