/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.metrics;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.table.QualifiedName;

public class StorageEngineTablesMetricSource
extends AbstractMetricSource<Holder> {
    public static final String METRIC_GROUP = "storage";
    private final Set<Metric> extraMetrics = new HashSet<Metric>();

    public StorageEngineTablesMetricSource(String engine, QualifiedName tableName) {
        super(StorageEngineTablesMetricSource.sourceName(engine, tableName), "\"" + engine + "\" storage engine metrics for the specific table.", METRIC_GROUP);
    }

    public static String sourceName(String engine, QualifiedName tableName) {
        return "storage." + engine + ".tables." + tableName.toCanonicalForm();
    }

    public void addMetric(Metric metric) {
        assert (this.holder() == null) : "Cannot add metrics when source is enabled";
        this.extraMetrics.add(metric);
    }

    protected Holder createHolder() {
        return new Holder(this.extraMetrics);
    }

    public static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final List<Metric> metrics;

        protected Holder(Set<Metric> extraMetrics) {
            this.metrics = List.copyOf(extraMetrics);
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

