/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.SecondaryStorageModule;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.secondary.SecondaryStorageEngine;
import org.apache.ignite.internal.vault.VaultManager;
import org.gridgain.internal.encryption.EncryptionManager;
import org.jetbrains.annotations.Nullable;

public class DataStorageModules {
    private static final IgniteLogger LOG = Loggers.forClass(DataStorageManager.class);
    private final Map<String, DataStorageModule> modules;
    private final Map<String, SecondaryStorageModule> secondaryStorageModules;

    public DataStorageModules(Iterable<DataStorageModule> dataStorageModules, Iterable<SecondaryStorageModule> secondaryStorageModules) {
        String name;
        HashMap<String, DataStorageModule> modules = new HashMap<String, DataStorageModule>();
        HashMap<String, SecondaryStorageModule> secondaryModules = new HashMap<String, SecondaryStorageModule>();
        for (DataStorageModule module : dataStorageModules) {
            name = module.name();
            if (modules.containsKey(name)) {
                throw new IllegalStateException(String.format("Duplicate name [name=%s, factories=%s]", name, List.of((DataStorageModule)modules.get(name), module)));
            }
            modules.put(name, module);
        }
        assert (!modules.isEmpty());
        for (SecondaryStorageModule secondaryModule : secondaryStorageModules) {
            name = secondaryModule.name();
            if (secondaryModules.containsKey(name)) {
                throw new IllegalStateException(String.format("Duplicate secondary storage name [name=%s, factories=%s]", name, List.of((SecondaryStorageModule)secondaryModules.get(name), secondaryModule)));
            }
            secondaryModules.put(name, secondaryModule);
        }
        this.modules = modules;
        this.secondaryStorageModules = secondaryModules;
    }

    public Map<String, StorageEngine> createStorageEngines(String igniteInstanceName, MetricManager metricManager, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, VaultManager vaultManager, EncryptionManager encryptionManager, LogSyncer logSyncer, HybridClock clock, ScheduledExecutorService commonScheduler) {
        return this.modules.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((DataStorageModule)e.getValue()).createEngine(igniteInstanceName, metricManager, configRegistry, storagePath, longJvmPauseDetector, failureManager, vaultManager, encryptionManager, logSyncer, clock, commonScheduler)));
    }

    public Map<String, SecondaryStorageEngine> createSecondaryStorageEngines(String igniteInstanceName, ConfigurationRegistry configRegistry, Path storagePath) {
        return this.secondaryStorageModules.values().stream().filter(SecondaryStorageModule::ready).map(module -> DataStorageModules.tryCreateSecondaryStorageEngine(module, igniteInstanceName, configRegistry, storagePath)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(SecondaryStorageEngine::name, Function.identity()));
    }

    @Nullable
    private static SecondaryStorageEngine tryCreateSecondaryStorageEngine(SecondaryStorageModule module, String igniteInstanceName, ConfigurationRegistry configRegistry, Path storagePath) {
        try {
            return module.createEngine(igniteInstanceName, configRegistry, storagePath);
        }
        catch (Throwable e) {
            LOG.warn(IgniteStringFormatter.format((String)"Secondary storage engine '{}' can't be started: {}", (Object[])new Object[]{module.name()}), e);
            return null;
        }
    }
}

