/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.secondary;

import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.TimedBinaryRowAndRowId;
import org.apache.ignite.internal.storage.operation.StorageOptimizedOperation;
import org.apache.ignite.internal.storage.secondary.BinaryRowAndRowId;
import org.apache.ignite.internal.storage.secondary.SecondaryStorage;
import org.apache.ignite.internal.storage.secondary.TimestampAndRowId;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.worker.ThreadAssertingCursor;
import org.apache.ignite.internal.worker.ThreadAssertions;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingSecondaryStorage
implements SecondaryStorage,
Wrapper {
    private final SecondaryStorage storage;

    ThreadAssertingSecondaryStorage(SecondaryStorage storage) {
        this.storage = storage;
    }

    @Override
    public void writeBatch(List<BinaryRowAndRowId> rows, HybridTimestamp timestamp) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.writeBatch(rows, timestamp);
    }

    @Override
    public void writeBatch(List<TimedBinaryRowAndRowId> rows) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.writeBatch(rows);
    }

    @Override
    @Nullable
    public BinaryRow read(BinaryRow key, HybridTimestamp timestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.read(key, timestamp);
    }

    @Override
    public Cursor<BinaryRow> scan(HybridTimestamp timestamp, @Nullable BitSet columnsToInclude) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor(this.storage.scan(timestamp, columnsToInclude));
    }

    @Override
    public Cursor<BinaryRow> scanWithOperation(HybridTimestamp timestamp, StorageOptimizedOperation operation) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor(this.storage.scanWithOperation(timestamp, operation));
    }

    @Override
    public TimestampAndRowId getLastPersistedRow() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.getLastPersistedRow();
    }

    @Override
    public int tableId() {
        return this.storage.tableId();
    }

    @Override
    public int partitionId() {
        return this.storage.partitionId();
    }

    @Override
    public void destroy() throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.destroy();
    }

    @Override
    public void updateRaftConfiguration(long lastAppliedIndex, long lastAppliedTerm) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.updateRaftConfiguration(lastAppliedIndex, lastAppliedTerm);
    }

    @Override
    public void updateRaftConfiguration(long lastAppliedIndex, long lastAppliedTerm, byte[] config) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.updateRaftConfiguration(lastAppliedIndex, lastAppliedTerm, config);
    }

    @Override
    public byte @Nullable [] getRaftNodeConfiguration() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.getRaftNodeConfiguration();
    }

    @Override
    public long getLastAppliedIndex() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.getLastAppliedIndex();
    }

    @Override
    public long getLastAppliedTerm() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.getLastAppliedTerm();
    }

    @Override
    public void updateLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.updateLease(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
    }

    @Override
    public long getLeaseStartTime() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.getLeaseStartTime();
    }

    @Override
    @Nullable
    public UUID getPrimaryReplicaNodeId() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.getPrimaryReplicaNodeId();
    }

    @Override
    @Nullable
    public String getPrimaryReplicaNodeName() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.getPrimaryReplicaNodeName();
    }

    @Override
    public void close() throws Exception {
        this.storage.close();
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.storage);
    }
}

