/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.util.UUID;
import org.apache.ignite.internal.storage.RowId;
import org.jetbrains.annotations.Nullable;

public class RowMeta {
    private final RowId rowId;
    @Nullable
    private final UUID transactionId;
    @Nullable
    private final Integer commitTableOrZoneId;
    private final int commitPartitionId;

    public static RowMeta withoutWriteIntent(RowId rowId) {
        return new RowMeta(rowId, null, null, -1);
    }

    public RowMeta(RowId rowId, @Nullable UUID transactionId, @Nullable Integer commitTableOrZoneId, int commitPartitionId) {
        this.rowId = rowId;
        this.transactionId = transactionId;
        this.commitTableOrZoneId = commitTableOrZoneId;
        this.commitPartitionId = commitPartitionId;
    }

    public RowId rowId() {
        return this.rowId;
    }

    @Nullable
    public UUID transactionId() {
        return this.transactionId;
    }

    public boolean isWriteIntent() {
        return this.transactionId != null;
    }

    @Nullable
    public Integer commitTableOrZoneId() {
        return this.commitTableOrZoneId;
    }

    public int commitPartitionId() {
        return this.commitPartitionId;
    }
}

