/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.tostring.S;

public class TimedBinaryRowAndRowId {
    private final BinaryRow binaryRow;
    private final RowId rowId;
    private final HybridTimestamp commitTimestamp;
    private final boolean tombstone;

    public TimedBinaryRowAndRowId(BinaryRow binaryRow, RowId rowId, HybridTimestamp commitTimestamp, boolean tombstone) {
        this.binaryRow = binaryRow;
        this.rowId = rowId;
        this.commitTimestamp = commitTimestamp;
        this.tombstone = tombstone;
    }

    public BinaryRow binaryRow() {
        return this.binaryRow;
    }

    public RowId rowId() {
        return this.rowId;
    }

    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    public boolean tombstone() {
        return this.tombstone;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedBinaryRowAndRowId that = (TimedBinaryRowAndRowId)o;
        return this.binaryRow.equals(that.binaryRow) && this.rowId.equals(that.rowId) && this.commitTimestamp.equals((Object)that.commitTimestamp) && this.tombstone == that.tombstone;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.binaryRow);
        result = 31 * result + this.rowId.hashCode();
        result = 31 * result + this.commitTimestamp.hashCode();
        result = 31 * result + (this.tombstone ? 1 : 0);
        return result;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

