/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.util.LockHolder;

public class LockByRowId {
    private final ConcurrentMap<RowId, LockHolder<ReentrantLock>> lockHolderByRowId = new ConcurrentHashMap<RowId, LockHolder<ReentrantLock>>();

    public void lock(RowId rowId) {
        LockHolder lockHolder = this.lockHolderByRowId.compute(rowId, (id, holder) -> {
            if (holder == null) {
                holder = new LockHolder<ReentrantLock>(new ReentrantLock());
            }
            if (!((ReentrantLock)holder.getLock()).isHeldByCurrentThread()) {
                holder.incrementHolders();
            }
            return holder;
        });
        if (!((ReentrantLock)lockHolder.getLock()).isHeldByCurrentThread()) {
            ((ReentrantLock)lockHolder.getLock()).lock();
        }
    }

    public boolean tryLock(RowId rowId) {
        boolean[] result = new boolean[]{false};
        this.lockHolderByRowId.compute(rowId, (id, holder) -> {
            if (holder == null) {
                holder = new LockHolder<ReentrantLock>(new ReentrantLock());
                holder.incrementHolders();
                holder.getLock().lock();
                result[0] = true;
            } else if (((ReentrantLock)holder.getLock()).isHeldByCurrentThread()) {
                result[0] = true;
            }
            return holder;
        });
        return result[0];
    }

    public void unlockAll(RowId rowId) {
        LockHolder lockHolder = (LockHolder)this.lockHolderByRowId.get(rowId);
        if (lockHolder == null) {
            throw new IllegalStateException("Could not find lock by row ID: " + rowId);
        }
        ReentrantLock lock = (ReentrantLock)lockHolder.getLock();
        lock.unlock();
        assert (!lock.isHeldByCurrentThread());
        this.lockHolderByRowId.compute(rowId, (id, holder) -> {
            assert (holder != null);
            return holder.decrementHolders() ? null : holder;
        });
    }
}

