/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.operation;

import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.storage.operation.StorageOptimizedOperation;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class AggregatedScan
implements StorageOptimizedOperation {
    @Nullable
    private final BitSet groupingColumns;
    private final List<Aggregate> aggregates;

    public AggregatedScan(@Nullable BitSet groupingColumns, List<Aggregate> aggregates) {
        this.groupingColumns = groupingColumns;
        this.aggregates = aggregates;
    }

    @Nullable
    public BitSet groupingColumns() {
        return this.groupingColumns;
    }

    public List<Aggregate> aggregates() {
        return this.aggregates;
    }

    public static class Aggregate {
        private final Function function;
        private final int columnIndex;

        public Aggregate(Function function, int columnIndex) {
            this.function = function;
            this.columnIndex = columnIndex;
        }

        public Function function() {
            return this.function;
        }

        public int columnIndex() {
            return this.columnIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Aggregate aggregate = (Aggregate)o;
            return this.columnIndex == aggregate.columnIndex && this.function == aggregate.function;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.columnIndex, this.function});
        }

        public String toString() {
            return S.toString((Object)this);
        }

        public static enum Function {
            COUNT,
            SUM,
            AVG,
            MIN,
            MAX,
            ANY_VALUE;

        }
    }
}

