/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.ignite.internal.sql.engine.hint.IgniteHint;
import org.apache.ignite.internal.util.ArrayUtils;

public final class HintUtils {
    private HintUtils() {
    }

    public static boolean isExpandDistinctAggregate(LogicalAggregate rel) {
        return rel.getHints().stream().anyMatch(r -> r.hintName.equals(IgniteHint.EXPAND_DISTINCT_AGG.name())) && rel.getAggCallList().stream().anyMatch(AggregateCall::isDistinct);
    }

    public static String toHint(IgniteHint hint, String ... params) {
        StringJoiner joiner = new StringJoiner(",", "/*+ " + hint.name() + "(", ") */");
        if (!ArrayUtils.nullOrEmpty((Object[])params)) {
            assert (hint.paramSupport());
            Arrays.stream(params).forEach(p -> joiner.add("'" + p + "'"));
        }
        return joiner.toString();
    }

    public static <T extends RelNode & Hintable> List<RelHint> hints(T rel, EnumSet<IgniteHint> hints) {
        List hintList = ((Hintable)rel).getHints().stream().filter(hint -> hints.contains((Object)IgniteHint.get(hint.hintName))).collect(Collectors.toList());
        return rel.getCluster().getHintStrategies().apply(hintList, rel);
    }

    public static boolean useSecondaryStorage(List<RelHint> hints) {
        return hints.stream().anyMatch(h -> IgniteHint.USE_SECONDARY_STORAGE.name().equals(h.hintName));
    }
}

