/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.tx;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapperImpl;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.tx.TransactionException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

public class QueryTransactionContextImpl
implements QueryTransactionContext {
    private final TxManager txManager;
    private final HybridTimestampTracker observableTimeTracker;
    @Nullable
    private final QueryTransactionWrapper tx;
    private final TransactionalOperationTracker txTracker;

    public QueryTransactionContextImpl(TxManager txManager, HybridTimestampTracker observableTimeTracker, @Nullable InternalTransaction tx, TransactionalOperationTracker txTracker) {
        this.txManager = txManager;
        this.observableTimeTracker = observableTimeTracker;
        this.tx = tx != null ? new QueryTransactionWrapperImpl(tx, false, txTracker) : null;
        this.txTracker = txTracker;
    }

    @Override
    public QueryTransactionWrapper getOrStartSqlManaged(boolean readOnly, boolean implicit, boolean cacheOnly) {
        QueryTransactionWrapper result;
        InternalTransaction transaction;
        if (this.tx == null) {
            transaction = cacheOnly ? this.txManager.beginExternal(this.observableTimeTracker, implicit) : (implicit ? this.txManager.beginImplicit(this.observableTimeTracker, readOnly, null) : this.txManager.beginExplicit(this.observableTimeTracker, readOnly, InternalTxOptions.defaults()));
            result = new QueryTransactionWrapperImpl(transaction, true, this.txTracker);
        } else {
            transaction = this.tx.unwrap();
            if (cacheOnly && transaction.isReadOnly()) {
                throw new TransactionException(GridgainErrorGroups.Cache.TX_INCOMPATIBLE_OPERATION_ERR, IgniteStringFormatter.format((String)"The cache can't be enlisted in read-only tx [tx={}]", (Object[])new Object[]{transaction}));
            }
            if (cacheOnly != transaction.external()) {
                throw new TransactionException(GridgainErrorGroups.Cache.TX_INCOMPATIBLE_OPERATION_ERR, IgniteStringFormatter.format((String)"Requested operation is incompatible with cache or table type [txId={}, cache={}]", (Object[])new Object[]{transaction.id(), true}));
            }
            result = this.tx;
        }
        this.txTracker.registerOperationStart(transaction);
        return result;
    }

    @Override
    public void updateObservableTime(HybridTimestamp time) {
        this.observableTimeTracker.update(time);
    }

    @Override
    @Nullable
    public QueryTransactionWrapper explicitTx() {
        return this.tx;
    }
}

