/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.apache.calcite.config.Lex;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.SourceStringReader;
import org.apache.calcite.util.Static;
import org.apache.ignite.internal.generated.query.calcite.sql.IgniteSqlParserImpl;
import org.apache.ignite.internal.generated.query.calcite.sql.IgniteSqlParserImplConstants;
import org.apache.ignite.internal.generated.query.calcite.sql.ParseException;
import org.apache.ignite.internal.generated.query.calcite.sql.Token;
import org.apache.ignite.internal.generated.query.calcite.sql.TokenMgrError;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlConformance;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDelete;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlMerge;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlUpdate;
import org.apache.ignite.internal.sql.engine.sql.ParseMode;
import org.apache.ignite.internal.sql.engine.sql.ParseResult;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteResource;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public final class IgniteSqlParser {
    public static final SqlParser.Config PARSER_CONFIG = SqlParser.config().withParserFactory(InternalIgniteSqlParser.FACTORY).withLex(Lex.ORACLE).withIdentifierMaxLength(Integer.MAX_VALUE).withConformance(IgniteSqlConformance.INSTANCE);

    private IgniteSqlParser() {
    }

    public static <T extends ParseResult> T parse(String sql, ParseMode<T> mode) {
        try (SourceStringReader reader = new SourceStringReader(sql);){
            T t = IgniteSqlParser.parse((Reader)reader, mode);
            return t;
        }
    }

    public static <T extends ParseResult> T parse(Reader reader, ParseMode<T> mode) {
        try {
            InternalIgniteSqlParser.dynamicParamCount.set(null);
            SqlParser parser = SqlParser.create((Reader)reader, (SqlParser.Config)PARSER_CONFIG);
            SqlNodeList nodeList = parser.parseStmtList();
            Integer dynamicParamsCount = InternalIgniteSqlParser.dynamicParamCount.get();
            assert (dynamicParamsCount != null) : "dynamicParamCount has not been updated";
            List list = nodeList.getList();
            PrepareSqlNodes visitor = new PrepareSqlNodes();
            for (int i = 0; i < list.size(); ++i) {
                SqlNode original = (SqlNode)list.get(i);
                SqlNode node = IgniteSqlParser.fixNodesIfNecessary(original);
                IgniteSqlParser.validateTopLevelNode(node);
                SqlNode newNode = (SqlNode)node.accept((SqlVisitor)visitor);
                list.set(i, newNode);
            }
            if (list.isEmpty()) {
                throw new SqlException(ErrorGroups.Sql.STMT_PARSE_ERR, "Failed to parse query: Not a statement");
            }
            T t = mode.createResult(list, dynamicParamsCount);
            return t;
        }
        catch (SqlParseException e) {
            throw IgniteSqlParser.convertException(e);
        }
        finally {
            InternalIgniteSqlParser.dynamicParamCount.set(null);
        }
    }

    private static void validateTopLevelNode(SqlNode node) throws SqlParseException {
        boolean knownType;
        boolean bl = knownType = Commons.getQueryType(node) != null;
        if (!knownType) {
            String sqlString = node.toString();
            int index1 = sqlString.indexOf(32);
            int index2 = index1 > 0 ? sqlString.indexOf(32, index1 + 1) : index1;
            String sql = sqlString.substring(0, index2);
            CalciteException cause = (CalciteException)IgniteResource.INSTANCE.unexpectedStatement(sql).ex();
            throw new SqlParseException(cause.getMessage(), node.getParserPosition(), null, null, (Throwable)cause);
        }
    }

    private static SqlException convertException(SqlParseException ex) {
        String message = IgniteSqlParser.normalizeMessage(ex);
        return new SqlException(ErrorGroups.Sql.STMT_PARSE_ERR, "Failed to parse query: " + message, (Throwable)ex);
    }

    public static String normalizeMessage(SqlParseException ex) {
        String message;
        Throwable cause = ex.getCause();
        if (cause instanceof ParseException) {
            ParseException parserEx = (ParseException)cause;
            if (parserEx.currentToken == null) {
                String originalMessage = parserEx.getMessage();
                int endOfTheFirstSentence = originalMessage.indexOf(".\n");
                message = originalMessage.substring(0, endOfTheFirstSentence);
            } else {
                Token tokenInQuestion = parserEx.currentToken.next;
                String tokenImage = StringUtils.nullOrBlank((String)tokenInQuestion.image) ? IgniteSqlParserImplConstants.tokenImage[tokenInQuestion.kind] : tokenInQuestion.image;
                message = IgniteStringFormatter.format((String)"Encountered \"{}\" at line {}, column {}", (Object[])new Object[]{tokenImage, tokenInQuestion.beginLine, tokenInQuestion.beginColumn});
            }
        } else if (cause instanceof TokenMgrError) {
            message = cause.getMessage();
        } else {
            String messageFromCause = cause.getMessage().trim();
            if (messageFromCause.endsWith(".")) {
                messageFromCause = messageFromCause.substring(0, messageFromCause.length() - 1);
            }
            message = IgniteStringFormatter.format((String)"{}. At line {}, column {}", (Object[])new Object[]{messageFromCause, ex.getPos().getLineNum(), ex.getPos().getColumnNum()});
        }
        return message;
    }

    private static SqlNode fixNodesIfNecessary(SqlNode node) {
        if (node.getKind() == SqlKind.DELETE) {
            return new IgniteSqlDelete((SqlDelete)node);
        }
        if (node.getKind() == SqlKind.UPDATE) {
            return new IgniteSqlUpdate((SqlUpdate)node);
        }
        if (node.getKind() == SqlKind.MERGE) {
            return new IgniteSqlMerge((SqlMerge)node);
        }
        return node;
    }

    private static final class InternalIgniteSqlParser
    extends IgniteSqlParserImpl {
        private static final SqlParserImplFactory FACTORY = new SqlParserImplFactory(){

            public SqlAbstractParserImpl getParser(Reader reader) {
                InternalIgniteSqlParser parser = new InternalIgniteSqlParser(reader);
                if (reader instanceof SourceStringReader) {
                    String sql = ((SourceStringReader)reader).getSourceString();
                    parser.setOriginalSql(sql);
                }
                return parser;
            }
        };
        static final ThreadLocal<Integer> dynamicParamCount = new ThreadLocal();

        InternalIgniteSqlParser(Reader reader) {
            super(reader);
        }

        @Override
        public SqlNode parseSqlExpressionEof() throws Exception {
            try {
                SqlNode sqlNode = super.parseSqlExpressionEof();
                return sqlNode;
            }
            finally {
                dynamicParamCount.set(this.nDynamicParams);
            }
        }

        @Override
        public SqlNode parseSqlStmtEof() throws Exception {
            try {
                SqlNode sqlNode = super.parseSqlStmtEof();
                return sqlNode;
            }
            finally {
                dynamicParamCount.set(this.nDynamicParams);
            }
        }

        @Override
        public SqlNodeList parseSqlStmtList() throws Exception {
            try {
                SqlNodeList sqlNodeList = super.parseSqlStmtList();
                return sqlNodeList;
            }
            finally {
                dynamicParamCount.set(this.nDynamicParams);
            }
        }
    }

    private static class PrepareSqlNodes
    extends SqlShuttle {
        private static final Map<String, SqlOperator> JDBC_FUNCTIONS = Map.of("{fn NOW}", IgniteSqlOperatorTable.CURRENT_TIMESTAMP);

        private PrepareSqlNodes() {
        }

        @Nullable
        public SqlNode visit(SqlIdentifier id) {
            for (int i = 0; i < id.names.size(); ++i) {
                String segment = (String)id.names.get(i);
                if (segment.isEmpty() && id.getComponent(i).isStar()) continue;
                PrepareSqlNodes.validateIdentifier(id.getComponentParserPosition(i), segment);
            }
            return super.visit(id);
        }

        @Nullable
        public SqlNode visit(SqlCall call) {
            SqlOperator operator = call.getOperator();
            if (operator != null) {
                SqlOperator replacement;
                PrepareSqlNodes.validateCall(call.getParserPosition(), operator.getName());
                if (operator instanceof SqlJdbcFunctionCall && (replacement = JDBC_FUNCTIONS.get(operator.getName())) != null) {
                    return new SqlBasicCall(replacement, call.getOperandList(), call.getParserPosition()).withExpanded(true);
                }
            }
            return super.visit(call);
        }

        @Nullable
        public SqlNode visit(SqlDataTypeSpec type) {
            SqlDataTypeSpec componentTypeSpec;
            this.visit(type.getTypeName());
            if (type.getTypeNameSpec() instanceof SqlCollectionTypeNameSpec && (componentTypeSpec = type.getComponentTypeSpec()) != null) {
                this.visit(componentTypeSpec);
            }
            return super.visit(type);
        }

        private static void validateCall(SqlParserPos pos, String segment) {
            int maxLength = 128;
            if (segment.length() > maxLength) {
                throw SqlUtil.newContextException((SqlParserPos)pos, (Resources.ExInst)Static.RESOURCE.identifierTooLong(segment, maxLength));
            }
        }

        private static void validateIdentifier(SqlParserPos pos, String segment) {
            int maxLength = 128;
            if (segment.length() > maxLength) {
                throw SqlUtil.newContextException((SqlParserPos)pos, (Resources.ExInst)Static.RESOURCE.identifierTooLong(segment, maxLength));
            }
            if (!pos.isQuoted() && !IgniteNameUtils.isValidNormalizedIdentifier((String)segment)) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Malformed identifier at line {}, column {}: {}", (Object[])new Object[]{pos.getLineNum(), pos.getColumnNum(), segment}));
            }
        }
    }
}

