/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.HintUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteTableScan
extends ProjectableFilterableTableScan
implements SourceAwareIgniteRel {
    private static final String REL_TYPE_NAME = "TableScan";
    private final long sourceId;
    private final boolean useSecondaryStorage;

    public IgniteTableScan(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
        this.useSecondaryStorage = input.getBoolean("useSecondaryStorage", false);
    }

    public IgniteTableScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl) {
        this(cluster, traits, tbl, List.of(), null, null, null, null);
    }

    public IgniteTableScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, List<RelHint> hints, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableIntList requiredColumns) {
        this(-1L, cluster, traits, hints, tbl, names, proj, cond, requiredColumns);
    }

    public IgniteTableScan(long sourceId, RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, RelOptTable tbl, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableIntList requiredColumns) {
        this(sourceId, cluster, traits, hints, tbl, HintUtils.useSecondaryStorage(hints), names, proj, cond, requiredColumns);
    }

    private IgniteTableScan(long sourceId, RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, RelOptTable tbl, boolean useSecondaryStorage, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableIntList requiredColumns) {
        super(cluster, traits, hints, tbl, names, proj, cond, requiredColumns);
        this.sourceId = sourceId;
        this.useSecondaryStorage = useSecondaryStorage;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    public boolean useSecondaryStorage() {
        return this.useSecondaryStorage;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        return super.explainTerms0(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L).itemIf("useSecondaryStorage", (Object)this.useSecondaryStorage, this.useSecondaryStorage);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rows = this.table.getRowCount();
        double cost = rows * 1.0;
        if (this.condition != null) {
            cost += rows * 3.0;
        }
        int fieldsCount = this.useSecondaryStorage && this.requiredColumns != null ? this.requiredColumns.size() : this.getRowType().getFieldCount();
        return planner.getCostFactory().makeCost(rows, cost, rows * (double)fieldsCount * 4.0);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteTableScan(sourceId, this.getCluster(), this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.useSecondaryStorage, this.names, this.projects, this.condition, this.requiredColumns);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteTableScan(this.sourceId, cluster, this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.useSecondaryStorage, this.names, this.projects, this.condition, this.requiredColumns);
    }

    @Override
    protected ProjectableFilterableTableScan copy(@Nullable List<RexNode> newProjects, @Nullable RexNode newCondition) {
        return new IgniteTableScan(this.sourceId, this.getCluster(), this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.names, newProjects, newCondition, this.requiredColumns);
    }

    public IgniteTableScan withHints(List<RelHint> hintList) {
        return new IgniteTableScan(this.sourceId, this.getCluster(), this.getTraitSet(), hintList, this.getTable(), this.useSecondaryStorage, this.names, this.projects, this.condition, this.requiredColumns);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        if (this.useSecondaryStorage) {
            writer.useSecondaryStorage(this.useSecondaryStorage);
        }
        return this.explainAttributes(writer);
    }
}

