/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.dcl;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.ignite.internal.sql.engine.prepare.dcl.AssignRolesCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.CreateRoleCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.CreateUserCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.DclCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.DropRoleCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.DropUserCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.PrivilegesCommand;
import org.apache.ignite.internal.sql.engine.prepare.dcl.RevokeRolesCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.UserAuthenticationMethod;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlCreateRole;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlCreateUser;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlDcl;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlDropRole;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlDropUser;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlGrantRevokePrivileges;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlGrantRoles;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlPrivileges;
import org.apache.ignite.internal.sql.engine.sql.dcl.GridgainSqlRevokeRoles;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.SqlException;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.ActionAlias;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.PrivilegeAlias;
import org.jetbrains.annotations.Nullable;

public class DclSqlToCommandConverter {
    private final Set<String> knownActionNames = EnumSet.allOf(Action.class).stream().map(Enum::name).collect(Collectors.toSet());

    public DclCommand convert(GridgainSqlDcl dclNode, String originalQuery) {
        if (dclNode instanceof GridgainSqlCreateUser) {
            return DclSqlToCommandConverter.convertCreateUser((GridgainSqlCreateUser)dclNode);
        }
        if (dclNode instanceof GridgainSqlDropUser) {
            return DclSqlToCommandConverter.convertDropUser((GridgainSqlDropUser)dclNode);
        }
        if (dclNode instanceof GridgainSqlCreateRole) {
            return DclSqlToCommandConverter.convertCreateRole((GridgainSqlCreateRole)dclNode);
        }
        if (dclNode instanceof GridgainSqlDropRole) {
            return DclSqlToCommandConverter.convertDropRole((GridgainSqlDropRole)dclNode);
        }
        if (dclNode instanceof GridgainSqlGrantRoles) {
            return DclSqlToCommandConverter.convertGrantRoles((GridgainSqlGrantRoles)dclNode);
        }
        if (dclNode instanceof GridgainSqlRevokeRoles) {
            return DclSqlToCommandConverter.convertRevokeRoles((GridgainSqlRevokeRoles)dclNode);
        }
        if (dclNode instanceof GridgainSqlGrantRevokePrivileges) {
            GridgainSqlGrantRevokePrivileges grantRevokePrivileges = (GridgainSqlGrantRevokePrivileges)dclNode;
            return this.convertGrantRevokePrivileges(grantRevokePrivileges.privileges(), grantRevokePrivileges.rolenames(), grantRevokePrivileges.isGrant(), originalQuery);
        }
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported operation [querySql=\"" + originalQuery + "\"]");
    }

    private static CreateUserCommand convertCreateUser(GridgainSqlCreateUser sqlCmd) {
        CreateUserCommand createUserCommand = new CreateUserCommand();
        createUserCommand.username(sqlCmd.username().getSimple());
        try {
            String authMethod = sqlCmd.authenticationMethod().getSimple();
            createUserCommand.authenticationMethod(UserAuthenticationMethod.valueOf(authMethod.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            throw new IgniteException(ErrorGroups.Sql.STMT_VALIDATION_ERR, String.format("Unexpected authentication method [option=%s, query=%s]", sqlCmd.authenticationMethod(), sqlCmd), (Throwable)e);
        }
        createUserCommand.password(sqlCmd.password());
        createUserCommand.ifNotExists(sqlCmd.ifNotExists());
        return createUserCommand;
    }

    private static DropUserCommand convertDropUser(GridgainSqlDropUser sqlCmd) {
        DropUserCommand dropUserCommand = new DropUserCommand();
        dropUserCommand.username(sqlCmd.username().getSimple());
        dropUserCommand.ifExists(sqlCmd.ifExists());
        return dropUserCommand;
    }

    private static CreateRoleCommand convertCreateRole(GridgainSqlCreateRole sqlCmd) {
        CreateRoleCommand createRoleCommand = new CreateRoleCommand();
        createRoleCommand.name(sqlCmd.name().getSimple());
        createRoleCommand.ifNotExists(sqlCmd.ifNotExists());
        return createRoleCommand;
    }

    private static DropRoleCommand convertDropRole(GridgainSqlDropRole sqlCmd) {
        DropRoleCommand dropRoleCommand = new DropRoleCommand();
        dropRoleCommand.name(sqlCmd.name().getSimple());
        dropRoleCommand.ifExists(sqlCmd.ifExists());
        return dropRoleCommand;
    }

    private static AssignRolesCommand convertGrantRoles(GridgainSqlGrantRoles sqlCmd) {
        AssignRolesCommand assignRolesCommand = new AssignRolesCommand();
        assignRolesCommand.rolenames(DclSqlToCommandConverter.converToStringSet(sqlCmd.rolenames()));
        assignRolesCommand.usernames(DclSqlToCommandConverter.converToStringSet(sqlCmd.usernames()));
        return assignRolesCommand;
    }

    private static RevokeRolesCommand convertRevokeRoles(GridgainSqlRevokeRoles sqlCmd) {
        RevokeRolesCommand revokeRolesCommand = new RevokeRolesCommand();
        revokeRolesCommand.rolenames(DclSqlToCommandConverter.converToStringSet(sqlCmd.rolenames()));
        revokeRolesCommand.usernames(DclSqlToCommandConverter.converToStringSet(sqlCmd.usernames()));
        return revokeRolesCommand;
    }

    private PrivilegesCommand convertGrantRevokePrivileges(GridgainSqlPrivileges privileges, SqlNodeList rolenamesList, boolean isGrant, String originalQuery) {
        Set<String> rolenames = DclSqlToCommandConverter.converToStringSet(rolenamesList);
        ActionAlias alias = privileges.alias();
        if (alias != null) {
            String rawSelector = privileges.object() != null ? privileges.object().getSimple() : null;
            PrivilegeAlias privilegeAlias = PrivilegeAlias.builder().alias(alias).selector(rawSelector).build();
            return new PrivilegesCommand(privilegeAlias, rolenames, isGrant);
        }
        return new PrivilegesCommand(this.convertToPrivilegesSet(privileges, originalQuery), rolenames, isGrant);
    }

    @Nullable
    private static Set<String> converToStringSet(@Nullable SqlNodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        return nodeList.getList().stream().map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).collect(Collectors.toSet());
    }

    private Set<Privilege> convertToPrivilegesSet(GridgainSqlPrivileges privileges, String originalQuery) {
        HashSet<String> remainingKnownActions = new HashSet<String>(this.knownActionNames);
        String rawSelector = privileges.object() != null ? privileges.object().getSimple() : null;
        return privileges.actions().stream().map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).map(String::toUpperCase).map(actionName -> {
            Action action = null;
            if (remainingKnownActions.remove(actionName)) {
                action = Action.valueOf((String)actionName);
            } else if (this.knownActionNames.contains(actionName)) {
                throw DclSqlToCommandConverter.duplicatePrivilegeAction(actionName, originalQuery);
            }
            if (action == null) {
                throw DclSqlToCommandConverter.unexpectedPrivilegeAction(actionName, originalQuery);
            }
            return Privilege.builder().selector(rawSelector).action(action).build();
        }).collect(Collectors.toSet());
    }

    private static IgniteException duplicatePrivilegeAction(String actionName, String originalQuery) {
        return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, String.format("Duplicate privilege action has been specified [action=%s, query=%s]", actionName, originalQuery));
    }

    private static IgniteException unexpectedPrivilegeAction(String actionName, String originalQuery) {
        return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, String.format("Unexpected privilege action [action=%s, query=%s]", actionName, originalQuery));
    }
}

